package com.digiwin.athena.atdm.datasource.datasource.process.dataUniformity;

import com.digiwin.athena.atdm.datasource.datasource.DataSourceProcessService;
import com.digiwin.athena.atdm.datasource.datasource.DataSourceBase;
import com.digiwin.athena.atdm.datasource.domain.DataSourceProcessor;
import com.digiwin.athena.atdm.datasource.domain.ExecuteContext;
import com.digiwin.athena.atdm.datasource.domain.QueryResult;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * @author：SYQ
 * @date：2022/5/13
 */
@Service("retainAbnormalDataService")
public class RetainAbnormalDataService implements DataSourceProcessService {

    @Autowired
    private DataUnfiormityProcessor dataUnfiormityProcessor;

    @Override
    public void handelMetadata(DataSourceBase dataSourceBase, ExecuteContext executeContext, DataSourceProcessor dataSourceProcessor, QueryResult queryResult) {
        //无需处理
    }

    @Override
    public void handelData(DataSourceBase dataSourceBase, ExecuteContext executeContext, DataSourceProcessor dataSourceProcessor, QueryResult queryResult) {
        List<Map<String,Object>> dataList = queryResult.getData();
        if(CollectionUtils.isEmpty(dataList) || null == dataSourceProcessor.getParas()){
            return;
        }
        //获取异动数据
        Set<Map<String,Object>> abnormalDataSet = dataUnfiormityProcessor.comparisonData(dataList,dataSourceProcessor);
        List<Map<String,Object>> abnormalDataList = new ArrayList<>();
        //去除处理方案为结束的
        for(Map<String,Object> dataMap : abnormalDataSet){
            if("end".equals(dataMap.get("dealType"))){
                continue;
            }
            abnormalDataList.add(dataMap);
        }
        queryResult.setData(abnormalDataList);
        queryResult.initializeDataKey();
    }
}
