package com.digiwin.athena.atdm.datasource.datasource.process.dataUniformity.eventbus;

import com.digiwin.athena.atdm.smartdata.CommonSmartDataService;
import com.google.common.eventbus.Subscribe;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.MapUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.Map;

/**
 * @author：SYQ
 * @date：2022/11/11
 */
@Component
@Slf4j
public class GiveupComparisonSubscriber {

    @Autowired
    private CommonSmartDataService commonSmartDataService;

    @Subscribe
    public void giveupComparisonData(GiveupComparisonEvent event){
        try {
            GiveupComparisonEventDTO eventDTO = event.getContent();
            log.info("GiveupComparisonSubscriber-eventDTO:{}",eventDTO);
            Map<String,Object> giveupMap = eventDTO.getBatchGiveUpMap();
            if(MapUtils.isEmpty(giveupMap)){
                return;
            }
            log.info("GiveupComparisonSubscriber-giveupMap:{}",giveupMap);
            commonSmartDataService.batchGiveupComparisonData(giveupMap);
        }catch (Exception e) {
            log.error("GiveupComparisonSubscriber-error:{}",e.getMessage());
        }
    }
}
