/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.atdm.datasource;

import cn.hutool.core.util.NumberUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.JSONPath;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.digiwin.athena.appcore.util.MessageUtils;
import com.digiwin.athena.atdm.dataUniformity.DataUniformityMongodbService;
import com.digiwin.athena.atdm.datasource.DataFetchingService;
import com.digiwin.athena.atdm.datasource.datasource.DataQuery;
import com.digiwin.athena.atdm.datasource.datasource.DataSourceBase;
import com.digiwin.athena.atdm.datasource.datasource.DataSourceSet;
import com.digiwin.athena.atdm.datasource.datasource.converter.DataSourceConverter;
import com.digiwin.athena.atdm.datasource.datasource.process.dataUniformity.DataUnfiormityProcessor;
import com.digiwin.athena.atdm.datasource.datasource.process.dataUniformity.RetainAbnormalAndAddColumnService;
import com.digiwin.athena.atdm.datasource.datasource.process.dataUniformity.RetainAbnormalDataService;
import com.digiwin.athena.atdm.datasource.domain.DataSourceProcessor;
import com.digiwin.athena.atdm.datasource.domain.DetailPageInfo;
import com.digiwin.athena.atdm.datasource.domain.ExecuteContext;
import com.digiwin.athena.atdm.datasource.domain.QueryResult;
import com.digiwin.athena.atdm.datasource.domain.QueryResultSet;
import com.digiwin.athena.atdm.datasource.dto.DataQueryDTO;
import com.digiwin.athena.atdm.datasource.dto.DataSourceDTO;
import com.digiwin.athena.atdm.datasource.dto.DataSourceSetDTO;
import com.digiwin.athena.atdm.datasource.dto.PageInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DataFetchingServiceImpl
implements DataFetchingService {
    protected static final Map<String, Object> ROW_APPEND_FIELDS = new HashMap<String, Object>();
    @Autowired
    DataUniformityMongodbService dataUniformityMongodbService;
    @Autowired
    RetainAbnormalDataService retainAbnormalDataService;
    @Autowired
    DataUnfiormityProcessor dataUnfiormityProcessor;
    @Autowired
    private MessageUtils messageUtils;
    @Autowired
    RetainAbnormalAndAddColumnService retainAbnormalAndAddColumnService;

    @Override
    public QueryResultSet queryWithMetaData(ExecuteContext executeContext, DataSourceSetDTO dataSourceSetDTO, Map<String, Object> parameter, PageInfo pageInfo, List<Map> sortInfo, List<Map> searchInfo) {
        if (dataSourceSetDTO == null) {
            throw new IllegalArgumentException("dataSourceSetDTO");
        }
        DataSourceSet dataSourceSet = DataSourceConverter.convert(dataSourceSetDTO);
        if (dataSourceSet == null) {
            return QueryResultSet.empty();
        }
        return dataSourceSet.queryWithMetaData(executeContext, parameter, pageInfo, sortInfo, searchInfo);
    }

    @Override
    @Deprecated
    public int size(ExecuteContext executeContext, DataSourceDTO dataSourceDTO, Map<String, Object> parameter, String sizeType) {
        if (dataSourceDTO == null) {
            return 0;
        }
        DataSourceBase dataSourceBase = DataSourceConverter.convert(dataSourceDTO, true);
        return dataSourceBase.size(executeContext, parameter, sizeType);
    }

    @Override
    public int size(DataQueryDTO dataQuery) {
        return this.size(dataQuery, dataQuery.getDataSource());
    }

    @Override
    public int size(DataQueryDTO dataQueryDto, DataSourceDTO dataSource) {
        if (dataSource == null) {
            return 0;
        }
        DataSourceBase dataSourceBase = DataSourceConverter.convert(dataSource, true);
        DataQuery dataQuery = DataQuery.builder().executeContext(dataQueryDto.getExecuteContext()).parameter(dataQueryDto.getParameter()).pageInfo(dataQueryDto.getPageInfo()).sortInfo(dataQueryDto.getSortInfo()).searchInfo(dataQueryDto.getSearchInfo()).rowSizeType(dataQueryDto.getRowSizeType()).build();
        return dataSourceBase.size(dataQuery);
    }

    @Override
    public QueryResultSet query(ExecuteContext executeContext, DataSourceSetDTO dataSourceSetDTO, Map<String, Object> parameter, PageInfo pageInfo, List<Map> sortInfo, List<Map> searchInfo) {
        if (dataSourceSetDTO == null) {
            throw new IllegalArgumentException("dataSourceSetDTO");
        }
        DataSourceSet dataSourceSet = DataSourceConverter.convert(dataSourceSetDTO);
        if (dataSourceSet == null) {
            return QueryResultSet.empty();
        }
        QueryResultSet queryResultSet = dataSourceSet.query(executeContext, parameter, pageInfo, sortInfo, searchInfo);
        if (pageInfo != null && pageInfo.isNextAllData() && pageInfo.getPageSize() != null) {
            queryResultSet.getMainQueryResult().removeTop(pageInfo.getPageSize());
        }
        if ("DATA_ENTRY".equals(executeContext.getPattern())) {
            this.appendField(queryResultSet.getPageData());
        }
        return queryResultSet;
    }

    @Override
    public void queryInfo(DataQueryDTO dataQueryDTO, QueryResultSet queryResultSet, Map result) {
        if (queryResultSet != null && queryResultSet.getMainQueryResult() != null) {
            if (dataQueryDTO.getPageInfo() != null) {
                PageInfo pageInfo = new PageInfo();
                pageInfo.setHasNext(queryResultSet.getMainQueryResult().isHasNext());
                pageInfo.setPageNo(dataQueryDTO.getPageInfo().getPageNo());
                pageInfo.setPageSize(dataQueryDTO.getPageInfo().getPageSize());
                pageInfo.setDetailName(dataQueryDTO.getPageInfo().getDetailName());
                pageInfo.setDetailPath(dataQueryDTO.getPageInfo().getDetailPath());
                Collection returnPageInfo = queryResultSet.getMainQueryResult().getReturnPageInfo();
                if (returnPageInfo != null) {
                    for (Map info : returnPageInfo) {
                        boolean o1 = Objects.equals(dataQueryDTO.getTempPageInfo().getDetailName(), info.get("detail_name"));
                        boolean o2 = Objects.equals(dataQueryDTO.getTempPageInfo().getDetailPath(), info.get("detail_path"));
                        if (!o1 || !o2) continue;
                        Object totalResults = info.get("total_results");
                        Object hasNext = info.get("has_next");
                        if (hasNext instanceof Boolean) {
                            pageInfo.setHasNext(((Boolean)hasNext).booleanValue());
                        } else if (hasNext instanceof String) {
                            pageInfo.setHasNext(Boolean.getBoolean((String)hasNext));
                        }
                        if (totalResults instanceof Number) {
                            pageInfo.setTotalResults(Integer.valueOf(NumberUtil.toBigDecimal((Number)((Number)totalResults)).intValue()));
                            continue;
                        }
                        if (totalResults instanceof String) {
                            pageInfo.setTotalResults(Integer.valueOf(NumberUtil.toBigDecimal((String)((String)totalResults)).intValue()));
                            continue;
                        }
                        pageInfo.setTotalResults(Integer.valueOf(0));
                    }
                } else if (queryResultSet.getMainQueryResult().getTotalResults() != null) {
                    double totalResults = Math.round(queryResultSet.getMainQueryResult().getTotalResults().intValue());
                    pageInfo.setTotalResults(Integer.valueOf((int)Math.floor(totalResults)));
                } else {
                    pageInfo.setTotalResults(Integer.valueOf(0));
                }
                result.put("pageInfo", pageInfo);
            }
            if (CollectionUtils.isNotEmpty(dataQueryDTO.getSortInfo())) {
                result.put("sortInfo", dataQueryDTO.getSortInfo());
            }
            if (CollectionUtils.isNotEmpty(dataQueryDTO.getSearchInfo())) {
                result.put("searchInfo", dataQueryDTO.getSearchInfo());
            }
        }
    }

    private void appendField(Map<String, Object> pageData) {
        if (MapUtils.isEmpty(pageData)) {
            return;
        }
        for (Object dataList : pageData.values()) {
            if (dataList instanceof List) {
                List rowDataList = (List)dataList;
                for (Object rowData : rowDataList) {
                    Map rowDataMap = (Map)rowData;
                    rowDataMap.putAll(ROW_APPEND_FIELDS);
                    if (!rowDataMap.containsKey("manage_status") || rowDataMap.get("manage_status") != null) continue;
                    rowDataMap.put("manage_status", "N");
                }
                continue;
            }
            if (!(dataList instanceof Map)) continue;
            Map rowDataMap = (Map)dataList;
            rowDataMap.putAll(ROW_APPEND_FIELDS);
        }
    }

    @Override
    public QueryResult querySingleResultWithMetaData(ExecuteContext executeContext, DataSourceDTO dataSourceDTO, Map<String, Object> parameter, PageInfo pageInfo, List<Map> sortInfo, List<Map> searchInfo) {
        if (dataSourceDTO == null) {
            throw new IllegalArgumentException("dataSourceDTO");
        }
        DataSourceBase dataSourceBase = DataSourceConverter.convert(dataSourceDTO, true);
        return dataSourceBase.queryWithMetaData(executeContext, parameter, pageInfo, sortInfo, searchInfo);
    }

    @Override
    public QueryResult querySingleResult(ExecuteContext executeContext, DataSourceDTO dataSourceDTO, Map<String, Object> parameter, PageInfo pageInfo, List<Map> sortInfo, List<Map> searchInfo) {
        if (dataSourceDTO == null) {
            throw new IllegalArgumentException("dataSourceDTO");
        }
        DataSourceBase dataSourceBase = DataSourceConverter.convert(dataSourceDTO, true);
        return dataSourceBase.query(executeContext, parameter, pageInfo, sortInfo, searchInfo);
    }

    @Override
    public Map<String, Integer> getDataSize(ExecuteContext executeContext, DataSourceDTO dataSourceDTO, Map<String, Object> parameter, String sizeType) {
        if (dataSourceDTO == null) {
            HashMap<String, Integer> map = new HashMap<String, Integer>();
            map.put("size", 0);
            map.put("abnormalSize", 0);
            return map;
        }
        DataSourceBase dataSourceBase = DataSourceConverter.convert(dataSourceDTO, true);
        return dataSourceBase.getDataSize(executeContext, parameter, sizeType);
    }

    @Override
    public void dealQueryResult(QueryResultSet queryResultSet, DataSourceProcessor dataSourceProcessor) {
        if (null == dataSourceProcessor) {
            return;
        }
        this.groupQueryResult(queryResultSet);
        QueryResult queryResult = (QueryResult)queryResultSet.getQueryResults().get(0);
        if ("removeAbnormalDataService".equals(dataSourceProcessor.getServiceName())) {
            this.removeAbnormalData(queryResult, dataSourceProcessor);
        } else {
            this.retainAbnormalData(queryResult, dataSourceProcessor);
        }
    }

    private void groupQueryResult(QueryResultSet queryResultSet) {
        Map<String, List<QueryResult>> group = queryResultSet.getQueryResults().stream().collect(Collectors.groupingBy(QueryResult::getDataSourceName));
        for (Map.Entry<String, List<QueryResult>> groupItem : group.entrySet()) {
            List<QueryResult> resultList = groupItem.getValue();
            if (resultList.size() <= 1) continue;
            QueryResult qr = resultList.get(0);
            for (int i = 1; i < resultList.size(); ++i) {
                qr.getData().addAll(resultList.get(i).getData());
                qr.getDataKeyIndex().putAll(resultList.get(i).getDataKeyIndex());
                if (CollectionUtils.isEmpty((Collection)qr.getDataKeys()) && CollectionUtils.isNotEmpty((Collection)resultList.get(i).getDataKeys())) {
                    qr.setDataKeys(resultList.get(i).getDataKeys());
                }
                if (qr.getApiMetadataCollection() == null && resultList.get(i).getApiMetadataCollection() != null) {
                    qr.withMetaData(resultList.get(i).getApiMetadataCollection());
                }
                queryResultSet.getQueryResults().remove(resultList.get(i));
            }
            queryResultSet.setMainQueryResult(qr);
        }
    }

    private void retainAbnormalData(QueryResult queryResult, DataSourceProcessor dataSourceProcessor) {
        List dataList = queryResult.getData();
        if (CollectionUtils.isEmpty((Collection)dataList) || null == dataSourceProcessor.getParas()) {
            return;
        }
        Set<Map<String, Object>> abnormalDataSet = this.dataUnfiormityProcessor.comparisonData(dataList, dataSourceProcessor);
        ArrayList<Map<String, Object>> abnormalDataList = new ArrayList<Map<String, Object>>();
        for (Map<String, Object> dataMap : abnormalDataSet) {
            String optTypeName = "0".equals(dataMap.get("optType")) ? this.messageUtils.getMessage("data_uniformity_optType_update") : this.messageUtils.getMessage("data_uniformity_optType_remove");
            dataMap.put("data_uniformity_optType", optTypeName);
            dataMap.put("data_uniformity_lastModifyTime", dataMap.get("lastModifyTime"));
            dataMap.put("data_uniformity_dealType", "");
            abnormalDataList.add(dataMap);
        }
        queryResult.setData(abnormalDataList);
        queryResult.initializeDataKey();
    }

    @Override
    public DataSourceProcessor judgeAbnormalProcessor(DataQueryDTO dataQueryDTO) {
        DataSourceProcessor dataSourceProcessor = null;
        if (dataQueryDTO == null || dataQueryDTO.getDataSourceSetDTO() == null || CollectionUtils.isEmpty((Collection)dataQueryDTO.getDataSourceSetDTO().getDataSourceList())) {
            return null;
        }
        DataSourceDTO dataSourceDTO = (DataSourceDTO)dataQueryDTO.getDataSourceSetDTO().getDataSourceList().get(0);
        List dataSourceProcessorList = dataSourceDTO.getDataSourceProcessors();
        if (CollectionUtils.isNotEmpty((Collection)dataSourceProcessorList)) {
            boolean isRemoveProcessor = false;
            for (DataSourceProcessor processor : dataSourceProcessorList) {
                if ("removeAbnormalDataService".equals(processor.getServiceName()) || "retainAbnormalDataService".equals(processor.getServiceName())) {
                    isRemoveProcessor = true;
                    dataSourceProcessor = processor;
                    break;
                }
                if (!"retainAbnormalAndAddColumnService".equals(processor.getServiceName())) continue;
                dataSourceProcessor = processor;
                break;
            }
            if (isRemoveProcessor) {
                dataSourceProcessorList.remove(dataSourceProcessor);
            }
        }
        return dataSourceProcessor;
    }

    private void removeAbnormalData(QueryResult queryResult, DataSourceProcessor dataSourceProcessor) {
        List dataList = queryResult.getData();
        if (CollectionUtils.isEmpty((Collection)dataList) || null == dataSourceProcessor.getParas()) {
            return;
        }
        Set<Map<String, Object>> abnormalDataSet = this.dataUnfiormityProcessor.comparisonData(dataList, dataSourceProcessor);
        ArrayList<Map> resultList = new ArrayList<Map>();
        for (Map dataMap : dataList) {
            if (abnormalDataSet.contains(dataMap)) continue;
            resultList.add(dataMap);
        }
        int totalKeySize = queryResult.keySize();
        queryResult.setData(resultList);
        queryResult.initializeDataKey();
        queryResult.setAbnormalDataSize(Integer.valueOf(abnormalDataSet.size()));
        queryResult.setAbnormalDataKeyIndexSize(Integer.valueOf(totalKeySize - queryResult.keySize()));
    }

    @Override
    public void dealDataQueryInfoBeforeQuery(DataQueryDTO dataQuery) {
        Map<String, Object> returnRequestData = dataQuery.getReturnRequestData();
        if (MapUtils.isNotEmpty(returnRequestData)) {
            dataQuery.setTempPageInfo(dataQuery.getPageInfo());
            PageInfo previousPageInfo = (PageInfo)JSON.parseObject((String)JSON.toJSONString((Object)returnRequestData.get("pageInfo")), PageInfo.class);
            ArrayList detailPageInfos = previousPageInfo.getDetailPageInfo();
            if (detailPageInfos == null) {
                detailPageInfos = new ArrayList();
            }
            PageInfo tempPageInfo = dataQuery.getTempPageInfo();
            String detailPath = (String)StringUtils.defaultIfBlank((CharSequence)tempPageInfo.getDetailPath(), (CharSequence)"");
            String detailName = (String)StringUtils.defaultIfBlank((CharSequence)tempPageInfo.getDetailName(), (CharSequence)"");
            Optional<DetailPageInfo> optionalDetailPageInfo = detailPageInfos.stream().filter(o -> Objects.equals(StringUtils.defaultIfBlank((CharSequence)o.getDetailPath(), (CharSequence)""), detailPath) && Objects.equals(detailName, StringUtils.defaultIfBlank((CharSequence)o.getDetailName(), (CharSequence)""))).findFirst();
            ArrayList<String> sonPath = new ArrayList<String>();
            if (optionalDetailPageInfo.isPresent()) {
                DetailPageInfo detailPageInfo1;
                String detailPath1;
                Optional<DetailPageInfo> parent;
                DetailPageInfo detailPageInfo = optionalDetailPageInfo.get();
                sonPath.add(detailPageInfo.getDetailName());
                while ((parent = detailPageInfos.stream().filter(o -> Objects.equals(StringUtils.defaultIfBlank((CharSequence)o.getDetailName(), (CharSequence)""), sonPath.get(sonPath.size() - 1))).findFirst()).isPresent() && !StringUtils.isBlank((CharSequence)(detailPath1 = (detailPageInfo1 = parent.get()).getDetailPath()))) {
                    sonPath.add(detailPath1);
                }
            }
            if (sonPath.size() > 0) {
                sonPath.remove(0);
            }
            this.replacePageInfo(previousPageInfo, dataQuery.getPageInfo(), sonPath);
            dataQuery.setPageInfo(previousPageInfo);
            List<Map> previousSortInfo = (List<Map>)JSON.parseObject((String)JSON.toJSONString((Object)returnRequestData.get("sortInfo")), (TypeReference)new TypeReference<List<Map>>(){}, (Feature[])new Feature[0]);
            previousSortInfo = this.replaceSortInfo(previousSortInfo, dataQuery.getSortInfo(), sonPath);
            dataQuery.setSortInfo(previousSortInfo);
            List<Map> previousSearchInfo = (List<Map>)JSON.parseObject((String)JSON.toJSONString((Object)returnRequestData.get("searchInfo")), (TypeReference)new TypeReference<List<Map>>(){}, (Feature[])new Feature[0]);
            previousSearchInfo = this.replaceSearchInfo(previousSearchInfo, dataQuery.getSearchInfo(), sonPath);
            dataQuery.setSearchInfo(previousSearchInfo);
        }
    }

    private List<Map> replaceSearchInfo(List<Map> previousSortInfo, List<Map> searchInfo, List<String> sonPath) {
        if (searchInfo == null) {
            searchInfo = new ArrayList<Map>();
        }
        if (previousSortInfo == null) {
            previousSortInfo = new ArrayList<Map>();
        }
        previousSortInfo.removeIf(next -> sonPath.contains(StringUtils.defaultIfBlank((CharSequence)String.valueOf(next.get("searchFieldPath")), (CharSequence)"")));
        previousSortInfo.addAll(searchInfo);
        return previousSortInfo;
    }

    private List<Map> replaceSortInfo(List<Map> previousSortInfo, List<Map> sortInfo, List<String> sonPath) {
        if (sortInfo == null) {
            sortInfo = new ArrayList<Map>();
        }
        if (previousSortInfo == null) {
            previousSortInfo = new ArrayList<Map>();
        }
        previousSortInfo.removeIf(next -> sonPath.contains(StringUtils.defaultIfBlank((CharSequence)String.valueOf(next.get("sortFieldPath")), (CharSequence)"")));
        previousSortInfo.addAll(sortInfo);
        return previousSortInfo;
    }

    private void replacePageInfo(PageInfo previousPageInfo, PageInfo paramPageInfo, List<String> sonPath) {
        List detailPageInfo;
        if (StringUtils.isBlank((CharSequence)previousPageInfo.getDetailName()) && StringUtils.isBlank((CharSequence)previousPageInfo.getDetailPath())) {
            previousPageInfo.setPageNo(paramPageInfo.getPageNo());
            previousPageInfo.setPageSize(paramPageInfo.getPageSize());
        }
        if (Objects.equals(StringUtils.defaultIfBlank((CharSequence)paramPageInfo.getDetailPath(), (CharSequence)""), StringUtils.defaultIfBlank((CharSequence)previousPageInfo.getDetailPath(), (CharSequence)"")) && Objects.equals(StringUtils.defaultIfBlank((CharSequence)paramPageInfo.getDetailName(), (CharSequence)""), StringUtils.defaultIfBlank((CharSequence)previousPageInfo.getDetailName(), (CharSequence)""))) {
            previousPageInfo.setPageNo(paramPageInfo.getPageNo());
            previousPageInfo.setPageSize(paramPageInfo.getPageSize());
        }
        if (CollectionUtils.isNotEmpty((Collection)(detailPageInfo = previousPageInfo.getDetailPageInfo()))) {
            paramPageInfo.setDetailPageInfo(detailPageInfo);
            for (DetailPageInfo tempPageInfo : detailPageInfo) {
                if (Objects.equals(paramPageInfo.getDetailPath(), tempPageInfo.getDetailPath()) && Objects.equals(paramPageInfo.getDetailName(), tempPageInfo.getDetailName())) {
                    tempPageInfo.setPageNo(paramPageInfo.getPageNo());
                    tempPageInfo.setPageSize(paramPageInfo.getPageSize());
                }
                if (!sonPath.contains(StringUtils.defaultIfBlank((CharSequence)tempPageInfo.getDetailPath(), (CharSequence)"")) || !sonPath.contains(StringUtils.defaultIfBlank((CharSequence)tempPageInfo.getDetailName(), (CharSequence)""))) continue;
                tempPageInfo.setPageNo(Integer.valueOf(1));
            }
        }
    }

    @Override
    public void dealPageDataAfterQuery(DataQueryDTO dataQuery, QueryResultSet queryResultSet, Map result) {
        JSONObject jsonObject;
        List detailPageInfos;
        Map<String, Object> returnRequestData = dataQuery.getReturnRequestData();
        if (returnRequestData != null && queryResultSet.getMainQueryResult() != null && CollectionUtils.isNotEmpty((Collection)(detailPageInfos = (List)JSON.parseObject((String)JSON.toJSONString((Object)JSONPath.eval((Object)(jsonObject = new JSONObject(returnRequestData)), (String)"$.pageInfo.detailPageInfo")), (TypeReference)new TypeReference<List<DetailPageInfo>>(){}, (Feature[])new Feature[0])))) {
            PageInfo tempPageInfo = dataQuery.getTempPageInfo();
            String detailPath = (String)StringUtils.defaultIfBlank((CharSequence)tempPageInfo.getDetailPath(), (CharSequence)"");
            String detailName = (String)StringUtils.defaultIfBlank((CharSequence)tempPageInfo.getDetailName(), (CharSequence)"");
            Optional<DetailPageInfo> optionalDetailPageInfo = detailPageInfos.stream().filter(o -> Objects.equals(StringUtils.defaultIfBlank((CharSequence)o.getDetailPath(), (CharSequence)""), detailPath) && Objects.equals(detailName, StringUtils.defaultIfBlank((CharSequence)o.getDetailName(), (CharSequence)""))).findFirst();
            if (optionalDetailPageInfo.isPresent()) {
                DetailPageInfo detailPageInfo1;
                String detailPath1;
                Optional<DetailPageInfo> parent;
                DetailPageInfo detailPageInfo = optionalDetailPageInfo.get();
                ArrayList<String> sorted = new ArrayList<String>();
                sorted.add(detailPageInfo.getDetailName());
                sorted.add(0, detailPageInfo.getDetailPath());
                while ((parent = detailPageInfos.stream().filter(o -> Objects.equals(StringUtils.defaultIfBlank((CharSequence)o.getDetailName(), (CharSequence)""), sorted.get(0))).findFirst()).isPresent() && !StringUtils.isBlank((CharSequence)(detailPath1 = (detailPageInfo1 = parent.get()).getDetailPath()))) {
                    sorted.add(0, detailPath1);
                }
                Map pageData = (Map)result.get("pageData");
                List pathList = sorted.stream().filter(StringUtils::isNotBlank).collect(Collectors.toList());
                if (pathList.size() > 0 && pageData != null) {
                    Object o2 = pageData.get(pathList.get(0));
                    for (int i = 1; i < pathList.size(); ++i) {
                        if (o2 instanceof Collection) {
                            o2 = this.getObject(o2, (String)pathList.get(i));
                            continue;
                        }
                        if (!(o2 instanceof Map)) continue;
                        o2 = ((Map)o2).get(pathList.get(i));
                    }
                    pageData.put(pathList.get(pathList.size() - 1), o2);
                }
            }
        }
    }

    private Object getObject(Object o, String path) {
        while (o instanceof Collection) {
            o = ((Collection)o).toArray()[0];
        }
        if (o instanceof Map) {
            o = ((Map)o).get(path);
        }
        return o;
    }

    static {
        ROW_APPEND_FIELDS.put("edit_type", 1);
    }
}

