/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.atdm.datasource.datasource.process;

import com.digiwin.athena.appcore.util.MessageUtils;
import com.digiwin.athena.appcore.util.SpringUtil;
import com.digiwin.athena.atdm.datasource.domain.BacklogData;
import com.digiwin.athena.atdm.datasource.domain.MetadataField;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.MapUtils;

public class ActivityUtils {
    public static final String ACTIVITY_START_TIME_STR = "activity__startTime";
    public static final String ACTIVITY_END_TIME_STR = "activity__endTime";

    public static void addActivityData(Map<String, Object> data, BacklogData backlogData) {
        data.put(ACTIVITY_START_TIME_STR, backlogData.getStartTime());
        data.put(ACTIVITY_END_TIME_STR, backlogData.getEndTime());
    }

    public static MetadataField createMetadataField(String name, String description) {
        MetadataField metadataField = new MetadataField();
        metadataField.setUiBot("Y");
        metadataField.setName(name);
        metadataField.setDataType("string");
        metadataField.setDescription(description);
        return metadataField;
    }

    public static void addActivityMetadataField(List<MetadataField> metadataFields, MessageUtils messageUtils) {
        metadataFields.add(ActivityUtils.createMetadataField(ACTIVITY_START_TIME_STR, messageUtils.getMessage("uibot.activity.metadataField.startTime")));
        metadataFields.add(ActivityUtils.createMetadataField(ACTIVITY_END_TIME_STR, messageUtils.getMessage("uibot.activity.metadataField.completionTime")));
    }

    public static void addActivityMetadataField(List<MetadataField> metadataFields) {
        ActivityUtils.addActivityMetadataField(metadataFields, (MessageUtils)SpringUtil.getBean(MessageUtils.class));
    }

    public static List<Map<String, Object>> addDispatchData(Map<String, Object> paras, Map<String, Object> parameter) {
        if (MapUtils.isEmpty(paras) || MapUtils.isEmpty(parameter)) {
            return null;
        }
        for (Map.Entry<String, Object> stringObjectEntry : parameter.entrySet()) {
            List dispatchDataList;
            if (stringObjectEntry.getKey().startsWith("uibot")) continue;
            Object value = stringObjectEntry.getValue();
            if (value instanceof Map) {
                Map row = (Map)value;
                if (row.isEmpty()) continue;
                HashMap dispatchData = Maps.newHashMapWithExpectedSize((int)2);
                ArrayList arrayList = Lists.newArrayList((Object[])new Map[]{row});
                dispatchData.put(stringObjectEntry.getKey(), arrayList);
                paras.put("dispatchData", dispatchData);
                return arrayList;
            }
            if (!(value instanceof List) || (dispatchDataList = (List)value).isEmpty()) continue;
            HashMap dispatchData = Maps.newHashMapWithExpectedSize((int)2);
            dispatchData.put(stringObjectEntry.getKey(), dispatchDataList);
            paras.put("dispatchData", dispatchData);
            return dispatchDataList;
        }
        return null;
    }
}

