/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.atdm.datasource.datasource.process;

import com.digiwin.athena.atdm.datasource.domain.BacklogData;
import com.digiwin.athena.atdm.datasource.domain.ExecuteContext;
import com.digiwin.athena.atdm.datasource.domain.TaskWithBacklogData;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class SolveUtil {
    public static void addTraceData(ExecuteContext executeContext, String detailField, TaskWithBacklogData taskWithBacklogData, BacklogData firstBacklogData, Map<String, Object> data) {
        JSONObject stateData = taskWithBacklogData.getStateData();
        SolveUtil.addTraceData(detailField, executeContext, data, firstBacklogData, taskWithBacklogData, stateData);
        if (detailField != null && data.get(detailField) != null) {
            List detail = (List)data.get(detailField);
            for (Map detailItem : detail) {
                SolveUtil.addTraceData(detailField, executeContext, detailItem, firstBacklogData, taskWithBacklogData, stateData);
            }
        }
    }

    static void addTraceData(String detailField, ExecuteContext executeContext, Map<String, Object> data, BacklogData firstBacklogData, TaskWithBacklogData taskWithBacklogData, JSONObject stateData) {
        if (stateData != null && !stateData.isEmpty()) {
            String existedItemKeyValue;
            String dataKeys = stateData.getString("dataKeys");
            String originalQueryVariableName = stateData.getString("originalQueryVariableName");
            JSONArray traceDataList = stateData.getJSONArray(originalQueryVariableName);
            String[] dataKeyList = dataKeys.split(";");
            String queryItemKeyValue = "";
            for (String keyItem : dataKeyList) {
                if (data.get(keyItem) == null) continue;
                queryItemKeyValue = queryItemKeyValue + data.get(keyItem).toString();
            }
            boolean isFind = false;
            for (Object item : traceDataList) {
                JSONObject dataItem = (JSONObject)item;
                existedItemKeyValue = "";
                for (String keyItem : dataKeyList) {
                    if (dataItem.get(keyItem) == null) continue;
                    existedItemKeyValue = existedItemKeyValue + dataItem.getString(keyItem);
                }
                if (!queryItemKeyValue.equals(existedItemKeyValue) || !dataItem.containsKey((Object)"processInstances") || CollectionUtils.isEmpty((Collection)dataItem.getJSONArray("processInstances"))) continue;
                dataItem.put((Object)"dataKeys", (Object)dataKeys);
                dataItem.put((Object)"backlogId", (Object)firstBacklogData.getBacklogId());
                dataItem.put((Object)"originalQueryVariableName", (Object)originalQueryVariableName);
                dataItem.put((Object)"solvePlanFieldName", stateData.get("solvePlanFieldName"));
                dataItem.put((Object)"taskProblematicData", stateData.get("taskProblematicData"));
                dataItem.put((Object)"approve", (Object)"");
                data.put("activity__approval__state", dataItem);
                isFind = true;
                break;
            }
            if (!isFind) {
                JSONObject dataItem = new JSONObject();
                dataItem.put((Object)"approve", (Object)"");
                data.put("activity__approval__state", dataItem);
            }
            if (!CollectionUtils.isEmpty((Collection)taskWithBacklogData.getAbortDataKeys())) {
                for (Object abortKey : taskWithBacklogData.getAbortDataKeys()) {
                    JSONObject akJSON = (JSONObject)abortKey;
                    existedItemKeyValue = "";
                    for (String keyItem : dataKeyList) {
                        if (akJSON.get("dataKey") == null || akJSON.getJSONObject("dataKey").get(keyItem) == null) continue;
                        existedItemKeyValue = existedItemKeyValue + akJSON.getJSONObject("dataKey").getString(keyItem);
                    }
                    if (!queryItemKeyValue.equals(existedItemKeyValue)) continue;
                    JSONObject dataItem = (JSONObject)data.get("activity__approval__state");
                    JSONObject abortAction = SolveUtil.createAbortTaskAction(detailField, executeContext, akJSON, firstBacklogData.getBacklogId(), taskWithBacklogData);
                    dataItem.put((Object)"abortAction", (Object)abortAction);
                    break;
                }
            }
        } else {
            JSONObject dataItem = new JSONObject();
            dataItem.put((Object)"approve", (Object)"");
            data.put("activity__approval__state", dataItem);
        }
    }

    static JSONObject createAbortTaskAction(String detailField, ExecuteContext executeContext, JSONObject abortData, Long backlogId, TaskWithBacklogData taskWithBacklogData) {
        JSONObject action = new JSONObject();
        action.put((Object)"id", (Object)"abort-task");
        action.put((Object)"title", (Object)"\u5173\u5361\u64a4\u56de");
        action.put((Object)"actionId", (Object)"abort-task");
        action.put((Object)"invokeType", (Object)"sync");
        action.put((Object)"category", (Object)"UIBOT");
        JSONObject serviceId = new JSONObject();
        serviceId.put((Object)"name", (Object)"abort-task");
        action.put((Object)"serviceId", (Object)serviceId);
        if (taskWithBacklogData.getBusinessUnit() != null) {
            action.put((Object)"businessUnit", (Object)taskWithBacklogData.getBusinessUnit());
        } else {
            action.put((Object)"businessUnit", (Object)executeContext.getBusinessUnit());
        }
        JSONObject extendParas = new JSONObject();
        extendParas.putAll((Map)abortData);
        if (!StringUtils.isEmpty((Object)detailField)) {
            extendParas.put((Object)"detailField", (Object)detailField);
        }
        action.put((Object)"extendParas", (Object)extendParas);
        JSONObject ec = new JSONObject();
        ec.put((Object)"tmProjectId", (Object)executeContext.getTmProjectId());
        ec.put((Object)"tmActivityId", (Object)executeContext.getTmActivityId());
        ec.put((Object)"pageCode", (Object)executeContext.getPageCode());
        ec.put((Object)"pattern", (Object)executeContext.getPattern());
        ec.put((Object)"category", (Object)executeContext.getCategory());
        ec.put((Object)"backlogId", (Object)backlogId);
        action.put((Object)"executeContext", (Object)ec);
        return action;
    }
}

