package com.digiwin.athena.atdm.action.apiError;

import com.digiwin.athena.appcore.auth.domain.AuthoredUser;

import java.util.List;
import java.util.Map;

public interface ApiErrorInfoService {

    /**
     * 保存请求和任务的关联关系
     * @param collectionName 租户id
     * @param dataMap
     */
    void  insertRequestWorkItem(String collectionName, Map<String,Object> dataMap);

    /**
     * 修改状态
     * @param collectionName
     * @param dataMap
     */
    void updateDataStatus(String collectionName,Map<String,Object> dataMap);

    /**
     * 查询数据
     * @return
     */
    Map<String,Object> queryDataByReqId(String collectionName, String reqId);


    /**
     * 向运维模组发送error_info
     */
    void sendApiErrorInfo(List<Object> errorInfos, Long ptmBacklogId, Long ptmWorkItemId, String ApiName);

    /**
     * esp全异步回调，向运维模组发送错误数据
     * @param reqId
     */
    void callBackApiErrorInfo(AuthoredUser user, String reqId, String data);
}
