package com.digiwin.athena.atdm.action.executor;

import com.digiwin.athena.atdm.ActionConstants;
import com.digiwin.athena.atdm.UiBotConstants;
import com.digiwin.athena.atdm.action.ActionExecutor;
import com.digiwin.athena.atdm.action.subscriber.event.AsaEvent;
import com.digiwin.athena.atdm.esp.CommonESPService;
import com.digiwin.athena.atdm.datasource.domain.ExecuteResult;
import com.digiwin.athena.atdm.datasource.domain.SubmitAction;
import com.digiwin.athena.atdm.datasource.domain.SubmitExecuteContext;
import com.google.common.eventbus.AsyncEventBus;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.MapUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.Map;

@Slf4j
@Order(0)
@Service("AsaActionExecutor")
class AsaActionExecutor implements ActionExecutor {

    @Autowired
    CommonESPService commonEspService;

    @Autowired
    private AsyncEventBus localEventBus;


    /**
     * 处理的类型是什么
     * @return
     */
    @Override
    public String supportKey(){
        return UiBotConstants.ACTION_CATEGORY_ASA + ActionConstants.SPLIT ;
    }

    @Override
    public ExecuteResult execute(SubmitExecuteContext executeContext,ExecuteResult parentExecuteResult, SubmitAction action, Map<String, Object> data) {
        if (action.getParas() == null) {
            action.setParas( new HashMap<>());
        }
        Map paras= action.getParas();
        for (Map.Entry<String, Object> stringObjectEntry : data.entrySet()) {
            paras.put(stringObjectEntry.getKey(),stringObjectEntry.getValue());
        }
        HashMap result = commonEspService.executeReturnAll(executeContext, action);
        HashMap dataMap = null;
        if(MapUtils.isNotEmpty(result) && result.containsKey("data") && null != result.get("data")){
            dataMap = (HashMap<String, Object>) result.get("data");
        }
        ExecuteResult executeResult = ExecuteResult.withData(dataMap);
        executeResult.setCompleted(false);

        // 娜娜帮我-调用记录
        AsaEvent asaEvent = new AsaEvent();
        asaEvent.setExecuteContext(executeContext);
        asaEvent.setAction(action);
        asaEvent.setResult(result);
        asaEvent.setDataMap(dataMap);
        localEventBus.post(asaEvent);

        return  executeResult;
    }
}
