package com.digiwin.athena.atdm.action.executor;
import com.digiwin.athena.atdm.UiBotConstants;
import com.digiwin.athena.atdm.action.ActionExecutor;
import com.digiwin.athena.atdm.datasource.domain.ExecuteResult;
import com.digiwin.athena.atdm.datasource.domain.SubmitAction;
import com.digiwin.athena.atdm.datasource.domain.SubmitExecuteContext;
import org.springframework.util.CollectionUtils;

import java.util.HashMap;
import java.util.Map;


/**
 * 合并数据提交的action
 */
public abstract class MergeDataActionExecutor implements ActionExecutor {
    @Override
    public ExecuteResult execute(SubmitExecuteContext executeContext,ExecuteResult parentExecuteResult, SubmitAction action, Map<String, Object> parameter) {
        if(action.getMergeDataAction() != null) {
            if (action.getExtendParas()!=null && action.getExtendParas().containsKey(UiBotConstants.MERGED_SUBMIT_DATA)) {
                return executeMergedData(executeContext, action, parameter);
            }else {
                ExecuteResult executeResult = collectMergeData(executeContext, action, parameter);
                executeResult.setExecuteState(Boolean.FALSE);
                return executeResult;
            }
        }else {
            return executeNotMergeData(executeContext, action, parameter);
        }
    }

    @Override
    public boolean supportDataMerge(){
        return true;
    }


    protected abstract ExecuteResult executeNotMergeData(SubmitExecuteContext executeContext, SubmitAction action, Map<String, Object> parameter);

    protected abstract ExecuteResult collectMergeData(SubmitExecuteContext executeContext, SubmitAction action, Map<String, Object> parameter);

    protected abstract ExecuteResult executeMergedData(SubmitExecuteContext executeContext, SubmitAction action, Map<String, Object> parameter);

    /**
     * 任务引擎使用
     * @param action
     * @param parameter
     */
    protected void setProcessVariables(SubmitAction action, Map<String, Object> parameter) {
        if (action.getParas() == null) {
            action.setParas(new HashMap<>());
        }
        if (!CollectionUtils.isEmpty(parameter)
                && !CollectionUtils.isEmpty(action.getExtendParas())
                && action.getExtendParas().containsKey("submitVariableName")) {
            String processVariableName = action.getExtendParas().get("submitVariableName").toString();
            Map para = action.getParas();
            Map<String, Object> processVariable = new HashMap<>();
            para.put("processVariables", processVariable);
            if ("SUBMIT_DATA".equals(processVariableName)) {
                for (Map.Entry<String, Object> stringObjectEntry : parameter.entrySet()) {
                    processVariable.put(stringObjectEntry.getKey(), stringObjectEntry.getValue());
                }
            } else if (parameter.containsKey(processVariableName)) {
                processVariable.put(processVariableName, parameter.get(processVariableName));
            }
        }
    }

  }
