package com.digiwin.athena.atdm.action.executor;

import com.digiwin.athena.atdm.ActionConstants;
import com.digiwin.athena.atdm.UiBotConstants;
import com.digiwin.athena.atdm.action.ActionExecutor;
import com.digiwin.athena.atdm.recycle.CommonRecycleService;
import com.digiwin.athena.atdm.datasource.domain.ExecuteResult;
import com.digiwin.athena.atdm.datasource.domain.SubmitAction;
import com.digiwin.athena.atdm.datasource.domain.SubmitExecuteContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.Map;

/**
 * RecycleDeleteAllExecutor Description
 *
 * @author majianfu
 * @date 2021/5/20
 * @since
 */
@Component
public class RecycleDeleteAllExecutor implements ActionExecutor {
    @Autowired
    private CommonRecycleService commonRecycleService;

    @Override
    public String supportKey() {
        return UiBotConstants.ACTION_CATEGORY_RECYCLE + ActionConstants.SPLIT + "recycle.deleteAll";
    }

    @Override
    public boolean supportRetry() {
        return true;
    }

    @Override
    public ExecuteResult execute(SubmitExecuteContext executeContext,ExecuteResult parentExecuteResult,  SubmitAction action, Map<String, Object> data) {
        commonRecycleService.deleteByActivityCode(executeContext.getAuthoredUser(), executeContext.getTmActivityId());
        return ExecuteResult.ok();
    }
}
