/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.atdm.action.apiError;

import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.exception.BusinessException;
import com.digiwin.athena.appcore.util.JsonUtils;
import com.digiwin.athena.atdm.action.apiError.ApiErrorInfoService;
import com.digiwin.athena.atdm.atmc.CommonAtmcService;
import com.digiwin.athena.atdm.atmc.dto.ApiErrorInfoDTO;
import com.digiwin.athena.atdm.constant.ErrorCodeEnum;
import com.digiwin.athena.atdm.mongodb.CommonMongodbService;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class ApiErrorInfoServiceImpl
implements ApiErrorInfoService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ApiErrorInfoServiceImpl.class);
    @Autowired
    private CommonMongodbService commonMongodbService;
    @Autowired(required=false)
    @Qualifier(value="espRequestWorkItemTemplate")
    private MongoTemplate espRequestWorkItemTemplate;
    @Autowired
    private CommonAtmcService atmcService;
    private static String ERROR_INFO = "errorInfo";

    private MongoTemplate getEspRequestWorkItemTemplate() {
        if (null != this.espRequestWorkItemTemplate) {
            return this.espRequestWorkItemTemplate;
        }
        throw BusinessException.create((String)"\u521b\u5efaespRequestWorkItemTemplate\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u6e90\u914d\u7f6e\u662f\u5426\u6b63\u786e~");
    }

    @Override
    public void insertRequestWorkItem(String collectionName, Map<String, Object> dataMap) {
        if (StringUtils.isEmpty((Object)collectionName)) {
            log.error("insertRequestWorkItem:collectionName is null");
            return;
        }
        if (this.checkData(dataMap)) {
            log.error("insertRequestWorkItem-dataMap:{}", (Object)JsonUtils.objectToString(dataMap));
            return;
        }
        HashMap<String, Integer> indexMap = new HashMap<String, Integer>();
        indexMap.put("reqId", 1);
        indexMap.put("ptmBacklogId", 1);
        indexMap.put("ptmWorkItemId", 1);
        this.commonMongodbService.createCollectionLock(this.getEspRequestWorkItemTemplate(), collectionName, indexMap);
        dataMap.put("status", 0);
        dataMap.put("createTime", LocalDateTime.now());
        dataMap.put("modifyTime", LocalDateTime.now());
        this.commonMongodbService.insert(this.getEspRequestWorkItemTemplate(), dataMap, collectionName);
    }

    @Override
    public void updateDataStatus(String collectionName, Map<String, Object> dataMap) {
        if (StringUtils.isEmpty((Object)collectionName)) {
            log.error("updateDataStatus:collectionName is null");
            return;
        }
        if (this.checkData(dataMap)) {
            log.error("updateDataStatus-dataMap:{}", (Object)JsonUtils.objectToString(dataMap));
            return;
        }
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"reqId").is(dataMap.get("reqId")).and("ptmBacklogId").is(dataMap.get("ptmBacklogId")).and("ptmWorkItemId").is(dataMap.get("ptmWorkItemId")));
        Update update = new Update();
        update.set(ERROR_INFO, dataMap.get(ERROR_INFO));
        update.set("status", (Object)1);
        update.set("modifyTime", (Object)LocalDateTime.now());
        this.commonMongodbService.updateFirst(this.getEspRequestWorkItemTemplate(), collectionName, query, update);
    }

    @Override
    public Map<String, Object> queryDataByReqId(String collectionName, String reqId) {
        if (StringUtils.isEmpty((Object)reqId)) {
            throw BusinessException.create((String)ErrorCodeEnum.API_ERR_PARAM_IS_NULL.getErrCode(), (String)"reqId is null");
        }
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"reqId").is((Object)reqId));
        List list = this.commonMongodbService.query(this.getEspRequestWorkItemTemplate(), collectionName, query);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            return (Map)list.get(0);
        }
        return null;
    }

    @Override
    public void sendApiErrorInfo(List<Object> errorInfos, Long ptmBacklogId, Long ptmWorkItemId, String ApiName) {
        if (CollectionUtils.isEmpty(errorInfos)) {
            return;
        }
        ApiErrorInfoDTO apiErrorInfoDTO = new ApiErrorInfoDTO();
        apiErrorInfoDTO.setErrorInfos(errorInfos);
        apiErrorInfoDTO.setPtmBacklogId(ptmBacklogId);
        apiErrorInfoDTO.setPtmWorkItemId(ptmWorkItemId);
        apiErrorInfoDTO.setApiName(ApiName);
        this.atmcService.sendApiErrorInfoMq(apiErrorInfoDTO);
    }

    @Override
    public void callBackApiErrorInfo(AuthoredUser user, String reqId, String data) {
        log.info("callBackApiErrorInfo-reqId:{}\uff0cuser:{}\uff0cdata:{}", new Object[]{reqId, JsonUtils.objectToString((Object)user), JsonUtils.objectToString((Object)data)});
        if (StringUtils.isEmpty((Object)reqId)) {
            throw BusinessException.create((String)ErrorCodeEnum.API_ERR_PARAM_IS_NULL.getErrCode(), (String)"reqId is null");
        }
        if (null == user) {
            throw BusinessException.create((String)ErrorCodeEnum.API_ERR_PARAM_IS_NULL.getErrCode(), (String)"user is null");
        }
        Map<String, Object> requestWorkItemData = this.queryDataByReqId(user.getTenantId(), reqId);
        if (MapUtils.isEmpty(requestWorkItemData)) {
            throw BusinessException.create((String)ErrorCodeEnum.API_ERR_PARAM_IS_NULL.getErrCode(), (String)"requestWorkItemData is null");
        }
        Long ptmBacklogId = Long.valueOf(requestWorkItemData.get("ptmBacklogId").toString());
        Long ptmWorkItemId = Long.valueOf(requestWorkItemData.get("ptmWorkItemId").toString());
        String apiName = String.valueOf(requestWorkItemData.get("apiName"));
        List<Object> errorInfos = this.getErrorInfos(data);
        this.sendApiErrorInfo(errorInfos, ptmBacklogId, ptmWorkItemId, apiName);
        HashMap<String, Object> mongoMap = new HashMap<String, Object>();
        mongoMap.put("reqId", reqId);
        mongoMap.put("ptmBacklogId", ptmBacklogId);
        mongoMap.put("ptmWorkItemId", ptmWorkItemId);
        mongoMap.put(ERROR_INFO, errorInfos);
        this.updateDataStatus(user.getTenantId(), mongoMap);
    }

    private boolean checkData(Map<String, Object> dataMap) {
        return MapUtils.isEmpty(dataMap) || !dataMap.containsKey("reqId") || !dataMap.containsKey("ptmWorkItemId") || !dataMap.containsKey("ptmBacklogId");
    }

    private List<Object> getErrorInfos(String data) {
        if (StringUtils.isEmpty((Object)data)) {
            return new ArrayList<Object>();
        }
        Map dataMap = (Map)JsonUtils.jsonToObject((String)data, Map.class);
        if (!dataMap.containsKey("std_data") || null == dataMap.get("std_data")) {
            return new ArrayList<Object>();
        }
        Map stdDataMap = (Map)dataMap.get("std_data");
        if (!stdDataMap.containsKey("parameter") || null == stdDataMap.get("parameter")) {
            return new ArrayList<Object>();
        }
        Map parameterMap = (Map)stdDataMap.get("parameter");
        if (!parameterMap.containsKey("error_info") || null == parameterMap.get("error_info")) {
            return new ArrayList<Object>();
        }
        return (List)parameterMap.get("error_info");
    }
}

