/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.atdm.action.util;

import com.digiwin.athena.atdm.datasource.domain.SubmitAction;
import com.digiwin.athena.atdm.datasource.domain.SubmitExecuteContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.apache.commons.collections4.CollectionUtils;

public abstract class ActionUtils {
    private static final List<String> COMMON_ACTION_CATEGORY = new ArrayList<String>();

    private ActionUtils() {
        COMMON_ACTION_CATEGORY.add("RECYCLE");
        COMMON_ACTION_CATEGORY.add("MANUAL_TASK");
        COMMON_ACTION_CATEGORY.add("ESP");
    }

    public static boolean isCalendarSubmitAction(SubmitAction action) {
        String tmActivityId = Optional.ofNullable(action.getExecuteContext()).map(SubmitExecuteContext::getTmActivityId).orElse("");
        if ("uibotManualTask".equals(tmActivityId)) {
            return true;
        }
        String pattern = Optional.ofNullable(action.getExecuteContext()).map(SubmitExecuteContext::getPattern).orElse("");
        return "CALENDAR".equals(pattern);
    }

    public static String getActionKey(SubmitAction action) {
        String actionKey = action.getCategory() + ":";
        switch (action.getCategory()) {
            case "RECYCLE": 
            case "TERMINATE_DATA": 
            case "WITHDRAW_DATA": 
            case "UIBOT": {
                actionKey = actionKey + action.getActionId();
                break;
            }
            case "TaskEngine": 
            case "PTM": {
                actionKey = actionKey + action.getServiceId().getName();
                break;
            }
            case "MANUAL_TASK": {
                break;
            }
        }
        return actionKey;
    }

    public static boolean notCommonSubmitAction(SubmitAction submitAction) {
        if (submitAction == null) {
            return false;
        }
        if (!COMMON_ACTION_CATEGORY.contains(submitAction.getActionId())) {
            return true;
        }
        List attachActions = submitAction.getAttachActions();
        if (CollectionUtils.isNotEmpty((Collection)attachActions)) {
            for (SubmitAction attachAction : attachActions) {
                if (!ActionUtils.notCommonSubmitAction(attachAction)) continue;
                return true;
            }
        }
        return false;
    }
}

