/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.atdm.action.subscriber;

import com.digiwin.athena.appcore.util.JsonUtils;
import com.digiwin.athena.atdm.action.apiError.ApiErrorInfoService;
import com.digiwin.athena.atdm.action.subscriber.event.ApiErrorEvent;
import com.digiwin.athena.atdm.datasource.domain.SubmitAction;
import com.digiwin.athena.atdm.datasource.domain.SubmitExecuteContext;
import com.google.common.eventbus.Subscribe;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ApiErrorSubscriber {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ApiErrorSubscriber.class);
    @Autowired
    private ApiErrorInfoService apiErrorInfoService;

    @Subscribe
    public void subscriber(ApiErrorEvent event) {
        try {
            this.processEvent(event);
        }
        catch (Exception e) {
            log.error("esp api\u63d0\u4ea4\u540e\u5411\u8fd0\u7ef4\u6a21\u7ec4\u53d1\u9001\u9519\u8bef\u6570\u636e\u5931\u8d25\uff1aevent:{},error:{}", (Object)JsonUtils.objectToString((Object)event), (Object)e.getMessage());
        }
    }

    private void processEvent(ApiErrorEvent event) {
        this.sendErrorInfo(event.getExecuteContext(), event.getAction(), event.getResult(), event.getDataMap());
    }

    private void sendErrorInfo(SubmitExecuteContext executeContext, SubmitAction action, HashMap result, HashMap dataMap) {
        if (MapUtils.isEmpty((Map)dataMap) || !dataMap.containsKey("error_info") || null == dataMap.get("error_info")) {
            log.error("EspActionExecutor-sendErrorInfo:error_info is empty");
            return;
        }
        if (null == executeContext || null == executeContext.getPtmData() || null == executeContext.getPtmData().get("ptmWorkItemId")) {
            log.error("EspActionExecutor-sendErrorInfo:ptmWorkItemId is null");
            return;
        }
        boolean sync = true;
        if (null != result.get("sync")) {
            sync = BooleanUtils.toBoolean((String)result.get("sync").toString());
        }
        if (sync) {
            List errorInfos = (List)dataMap.get("error_info");
            Long ptmBacklogId = (Long)executeContext.getPtmData().get("ptmBacklogId");
            Long ptmWorkItemId = (Long)executeContext.getPtmData().get("ptmWorkItemId");
            String apiName = action.getServiceId().getName();
            this.apiErrorInfoService.sendApiErrorInfo(errorInfos, ptmBacklogId, ptmWorkItemId, apiName);
        } else {
            HashMap<String, Object> insertMap = new HashMap<String, Object>();
            insertMap.put("ptmBacklogId", executeContext.getPtmData().get("ptmBacklogId"));
            insertMap.put("ptmWorkItemId", executeContext.getPtmData().get("ptmWorkItemId"));
            insertMap.put("apiName", action.getServiceId().getName());
            insertMap.put("reqId", result.get("reqId"));
            this.apiErrorInfoService.insertRequestWorkItem(executeContext.getTenantId(), insertMap);
        }
    }
}

