package com.digiwin.athena.atdm.action.executor;

import com.digiwin.athena.atdm.datasource.ActionExecuteReq;
import com.digiwin.athena.atdm.datasource.domain.ExecuteResult;
import com.digiwin.athena.atdm.datasource.domain.SubmitAction;
import com.digiwin.athena.atdm.datasource.domain.SubmitExecuteContext;

import java.util.Map;

public interface DataSubmissionService {
    /**
     * 是否支持该提交Action
     *
     * @param action 提交action定义
     * @return true：支持，false：不支持
     */
    boolean isSupportSubmitAction(SubmitAction action);

    boolean isSupportSubmitMergeData(SubmitAction action);

    /**
     * 执行提交的action
     *
     * @param executeContext
     * @param action
     * @param data
     * @return
     */
    ExecuteResult execute(SubmitExecuteContext executeContext, SubmitAction action, Map<String, Object> data);

    /**
     * 执行提交的action
     *
     * @param executeContext
     * @param action
     * @param data
     * @return
     */
    default ExecuteResult submit(SubmitExecuteContext executeContext, SubmitAction action, Map<String, Object> data) {
        return submit(new ActionExecuteReq(executeContext, null, action, data));
    }

    //
    ExecuteResult submit(ActionExecuteReq actionExecuteReq);


    /**
     * 执行记录返回结果
     *
     * @param executeContext
     * @param parentExecuteResult
     * @param action
     * @param data
     * @return
     */
    ExecuteResult executeCoreWapper(SubmitExecuteContext executeContext, ExecuteResult parentExecuteResult, SubmitAction action, Map<String, Object> data);

    ExecuteResult executeCoreWapper(ActionExecuteReq req);

    void executeAttachAction(SubmitExecuteContext executeContext, SubmitAction parentAction, ExecuteResult parentExecuteResult, SubmitAction attachAction, Map<String, Object> submitData);

    void executeAttachAction(ActionExecuteReq actionExecuteReq);
}
