package com.digiwin.athena.atdm.action.executor;

import com.digiwin.athena.atdm.ActionConstants;
import com.digiwin.athena.atdm.UiBotConstants;
import com.digiwin.athena.atdm.action.ActionExecutor;
import com.digiwin.athena.atdm.action.subscriber.event.ApiErrorEvent;
import com.digiwin.athena.atdm.action.subscriber.event.AsaEvent;
import com.digiwin.athena.atdm.esp.CommonESPService;
import com.digiwin.athena.atdm.datasource.domain.ExecuteResult;
import com.digiwin.athena.atdm.datasource.domain.SubmitAction;
import com.digiwin.athena.atdm.datasource.domain.SubmitExecuteContext;
import com.digiwin.athena.atdm.datasource.domain.SubmitType;
import com.google.common.eventbus.AsyncEventBus;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.Map;

@Slf4j
@Order(0)
@Service("EspActionExecutor")
class EspActionExecutor implements ActionExecutor {

    @Autowired
    CommonESPService commonEspService;

    @Autowired
    private AsyncEventBus localEventBus;


    /**
     * 处理的类型是什么
     * @return
     */
    @Override
    public String supportKey(){
        return UiBotConstants.ACTION_CATEGORY_ESP + ActionConstants.SPLIT ;
    }

    @Override
    public boolean supportRetry() {
        return true;
    }

    @Override
    public ExecuteResult execute(SubmitExecuteContext executeContext,ExecuteResult parentExecuteResult, SubmitAction action, Map<String, Object> data) {
//        log.info("EspActionExecutor-execute,executeContext:{},parentExecuteResult:{},action:{},data:{}",
//                JsonUtils.objectToString(executeContext),JsonUtils.objectToString(parentExecuteResult),JsonUtils.objectToString(action),JsonUtils.objectToString(data));
        if (action.getParas() == null) {
            action.setParas( new HashMap<>());
        }
        Map paras= action.getParas();
        for (Map.Entry<String, Object> stringObjectEntry : data.entrySet()) {
            paras.put(stringObjectEntry.getKey(),stringObjectEntry.getValue());
        }
        HashMap result = commonEspService.executeReturnAll(executeContext, action);
//        HashMap result = new HashMap();
//        result.put("reqId", "asaTest" + executeContext.getBacklogId());

//        log.info("EspActionExecutor-result:{}",JsonUtils.objectToString(result));
        HashMap<String, Object> dataMap = null;
        if(MapUtils.isNotEmpty(result) && result.containsKey("data") && null != result.get("data")){
            dataMap = (HashMap<String, Object>) result.get("data");
            // 需求:110565 解决在api为get和create的情况返回的数据源名称不一致的情况，如get的结构为:{a:[]}，create的结构为: {b:[]}经过处理create改为:{a:[],b:[]},其中a,b数据一致
            SubmitType submitType = action.getSubmitType();
            if(submitType != null){
                String schema = submitType.getSchema();
                if(StringUtils.isNotBlank(schema) && !dataMap.containsKey(schema)){
                    for(Map.Entry<String, Object> returnInfo : dataMap.entrySet()){
                        if(!"error_info".equals(returnInfo.getKey()) && !"success_info".equals(returnInfo.getKey())){
                            dataMap.put(schema, returnInfo.getValue());
                            break;
                        }
                    }
                }
            }
        }
        ExecuteResult executeResult = ExecuteResult.withData(dataMap);
        executeResult.setCompleted(false);

        //运维模组-错误数据
        ApiErrorEvent apiErrorEvent = new ApiErrorEvent();
        apiErrorEvent.setExecuteContext(executeContext);
        apiErrorEvent.setAction(action);
        apiErrorEvent.setResult(result);
        apiErrorEvent.setDataMap(dataMap);
        localEventBus.post(apiErrorEvent);

        // 娜娜帮我-调用记录
        AsaEvent asaEvent = new AsaEvent();
        asaEvent.setExecuteContext(executeContext);
        asaEvent.setAction(action);
        asaEvent.setResult(result);
        asaEvent.setDataMap(data);
        localEventBus.post(asaEvent);

        return  executeResult;
    }




}
