package com.digiwin.athena.atdm.action.util;

import com.digiwin.athena.atdm.ActionConstants;
import com.digiwin.athena.atdm.UiBotConstants;
import com.digiwin.athena.atdm.datasource.domain.SubmitAction;
import com.digiwin.athena.atdm.datasource.domain.SubmitExecuteContext;
import org.apache.commons.collections4.CollectionUtils;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;

public abstract class ActionUtils {
    private static final List<String> COMMON_ACTION_CATEGORY = Arrays.asList(UiBotConstants.ACTION_CATEGORY_RECYCLE,
            UiBotConstants.ACTION_CATEGORY_MANUAL_TASK,
            UiBotConstants.ACTION_CATEGORY_ESP,
            UiBotConstants.ACTION_CATEGORY_WORKFLOW);

    /**
     * 是否为行事历任务的提交
     *
     * @param action
     */
    public static boolean isCalendarSubmitAction(SubmitAction action) {
        // 平台级行事历任务，action.executeContext.tmActivityId为固定值（很奇怪，为啥executeContext.pattern值为null）
        String tmActivityId = Optional.ofNullable(action.getExecuteContext()).map(SubmitExecuteContext::getTmActivityId).orElse("");
        if (UiBotConstants.PLATFORM_CALENDAR_CODE.equals(tmActivityId)) {
            return true;
        }

        // 应用级行事历任务，action.executeContext.pattern为固定值
        String pattern = Optional.ofNullable(action.getExecuteContext()).map(SubmitExecuteContext::getPattern).orElse("");
        return UiBotConstants.PATTERN_CALENDAR.equals(pattern);
    }

    public static String getActionKey(SubmitAction action) {
        String actionKey = action.getCategory() + ActionConstants.SPLIT;
        switch (action.getCategory()) {
            case UiBotConstants.ACTION_CATEGORY_RECYCLE:
            case UiBotConstants.ACTION_CATEGORY_TERMINATE_DATA:
            case UiBotConstants.ACTION_CATEGORY_WITHDRAW_DATA:
            case UiBotConstants.ACTION_CATEGORY_UIBOT: {
                actionKey += action.getActionId();
                break;
            }
            case UiBotConstants.ACTION_CATEGORY_TASK_ENGINE:
            case UiBotConstants.ACTION_CATEGORY_PTM:
                actionKey += action.getServiceId().getName();
                break;
            case UiBotConstants.ACTION_CATEGORY_MANUAL_TASK:
                break;
            case UiBotConstants.DATA_LCDP:
                break;
        }
        return actionKey;
    }

    /**
     * 非通用Action，如：任务、项目、SD等相关
     *
     * @param submitAction
     * @return
     */
    public static boolean notCommonSubmitAction(SubmitAction submitAction) {
        if (submitAction == null) {
            return false;
        }
        // 包含非通用Action（如：SD、任务、项目相关）
        if (!COMMON_ACTION_CATEGORY.contains(submitAction.getCategory())) {
            return true;
        }

        List<SubmitAction> attachActions = submitAction.getAttachActions();
        if (CollectionUtils.isNotEmpty(attachActions)) {
            for (SubmitAction attachAction : attachActions) {
                if (notCommonSubmitAction(attachAction)) {
                    return true;
                }
            }
        }
        return false;
    }
}
