package com.digiwin.athena.atdm.action.subscriber;

import com.digiwin.athena.appcore.util.JsonUtils;
import com.digiwin.athena.atdm.action.subscriber.event.AsaEvent;
import com.digiwin.athena.atdm.action.apiError.ApiErrorInfoService;
import com.digiwin.athena.atdm.atmc.CommonAtmcService;
import com.digiwin.athena.atdm.datasource.domain.SubmitAction;
import com.digiwin.athena.atdm.datasource.domain.SubmitExecuteContext;
import com.google.common.eventbus.Subscribe;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.HashMap;
import java.util.Map;

import static com.digiwin.athena.atdm.action.constant.CallbackConstants.API_NAME;
import static com.digiwin.athena.atdm.action.constant.CallbackConstants.PRODUCT;
import static com.digiwin.athena.atdm.action.constant.CallbackConstants.PROJECT_DEF_CODE;
import static com.digiwin.athena.atdm.action.constant.CallbackConstants.PTM_BACKLOG_ID;
import static com.digiwin.athena.atdm.action.constant.CallbackConstants.PTM_WORK_ITEM_ID;
import static com.digiwin.athena.atdm.action.constant.CallbackConstants.REQ_ID;
import static com.digiwin.athena.atdm.action.constant.CallbackConstants.TARGET_TENANT_ID;
import static com.digiwin.athena.atdm.action.constant.CallbackConstants.TASK_DEF_CODE;
import static com.digiwin.athena.atdm.action.constant.CallbackConstants.TENANT_ID;

/**
 * asa回调
 */
@Component
@Slf4j
public class AsaSubscriber {

    @Autowired
    private CommonAtmcService atmcService;

    @Autowired
    private ApiErrorInfoService apiErrorInfoService;

    @Subscribe
    public void subscriber(AsaEvent event){
        try {
            log.info("ApiErrorEvent:{}",JsonUtils.objectToString(event));
            processEvent(event);
        } catch (Exception e) {
            log.error("asa api提交报错请求和任务的关联关系失败：event:{},error:{}",JsonUtils.objectToString(event),e.getMessage());
        }
    }

    /**
     *
     * @param event
     */
    private void processEvent(AsaEvent event){
        saveCallRecord(event.getExecuteContext(),event.getAction(),event.getResult(),event.getDataMap());

    }

    /**
     *
     * @param executeContext
     * @param dataMap
     */
    private void saveCallRecord(SubmitExecuteContext executeContext, SubmitAction action, HashMap result, Map dataMap){
        log.info("EspActionExecutor-sendErrorInfo-executeContext:{}",JsonUtils.objectToString(executeContext));
        log.info("EspActionExecutor-sendErrorInfo-dataMap:{}",JsonUtils.objectToString(dataMap));
        // 没有事项id
        if (null == executeContext || null == executeContext.getPtmData() || null == executeContext.getPtmData().get("ptmWorkItemId")){
            log.error("EspActionExecutor-sendErrorInfo:ptmWorkItemId is null");
            return;
        }
        Map<String,Object> insertMap = new HashMap<>();
        insertMap.put(PTM_BACKLOG_ID,executeContext.getPtmData().get(PTM_BACKLOG_ID));
        insertMap.put(PTM_WORK_ITEM_ID,executeContext.getPtmData().get(PTM_WORK_ITEM_ID));
        insertMap.put(API_NAME,action.getServiceId().getName());
        insertMap.put(REQ_ID,result.get(REQ_ID));
        insertMap.put(PRODUCT,action.getServiceId().getProd());
        insertMap.put(TASK_DEF_CODE,executeContext.getTmActivityId());
        insertMap.put(PROJECT_DEF_CODE,executeContext.getTmProjectId());
        insertMap.put(TENANT_ID, dataMap.get("tenant_id"));
        insertMap.put(TARGET_TENANT_ID, dataMap.get("target_tenant_id"));
        log.info("AsaSubscriber-insertMap:{}", JsonUtils.objectToString(insertMap));
        apiErrorInfoService.insertRequestWorkItem(executeContext.getTenantId(),insertMap);
    }

}
