package com.digiwin.athena.idrive.common;


import com.mongodb.MongoClientSettings;
import com.mongodb.client.MongoClient;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.mongo.*;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.core.env.Environment;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.SimpleMongoClientDatabaseFactory;
import org.springframework.data.mongodb.core.mapping.MongoMappingContext;

import java.util.stream.Collectors;
@EnableConfigurationProperties(MongoProperties.class)
@Configuration
public class IdcMongoConfiguration {

    MongoAutoConfiguration mongoAutoConfiguration;

    @Value("${spring.data.mongodb.database:null}")
    private String database;

    @Primary
    @Bean
    MongoClientSettings mongoClientSettings() {
        return MongoClientSettings.builder().build();
    }

    @Bean
    MongoPropertiesClientSettingsBuilderCustomizer mongoPropertiesCustomizer(MongoProperties properties,
                                                                             Environment environment) {
        return new MongoPropertiesClientSettingsBuilderCustomizer(properties, environment);
    }

    @Bean
    @Primary
    public MongoClient mongo(ObjectProvider<MongoClientSettingsBuilderCustomizer> builderCustomizers,
                             MongoClientSettings settings) {
        return new MongoClientFactory(builderCustomizers.orderedStream().collect(Collectors.toList())).createMongoClient(settings);
    }


    @Bean
    @Primary
    public SimpleMongoClientDatabaseFactory simpleMongoClientDatabaseFactory(MongoClient mongoClient){

        return new SimpleMongoClientDatabaseFactory(mongoClient,database);
    }

//    @Primary
//    @Bean
//    public MongoClientOptions mongoClientOptions0() {
//        MongoClientOptions.Builder builder = new MongoClientOptions.Builder();
//        builder.connectionsPerHost(500);
//        builder.threadsAllowedToBlockForConnectionMultiplier(10);
//        builder.maxWaitTime(60000);
//        builder.connectTimeout(10000);
//        builder.maxConnectionLifeTime(5*60*1000);
//        builder.addConnectionPoolListener(new ConnectionPoolListener() {
//            @Override
//            public void connectionPoolOpened(ConnectionPoolOpenedEvent event) {
//                System.out.println("mongo pool opened "+event.getServerId());
//            }
//
//            @Override
//            public void connectionPoolClosed(ConnectionPoolClosedEvent event) {
//                System.out.println("mongo pool closed "+event.getServerId());
//            }
//
//            @Override
//            public void connectionCheckedOut(ConnectionCheckedOutEvent event) {
//                connectCheck.incrementAndGet();
//
//            }
//
//            @Override
//            public void connectionCheckedIn(ConnectionCheckedInEvent event) {
//                connectCheck.decrementAndGet();
//            }
//
//            //    @Override
//            public void waitQueueEntered(ConnectionPoolWaitQueueEnteredEvent event) {
//                waitQueue.incrementAndGet();
//            }
//
//            //   @Override
//            public void waitQueueExited(ConnectionPoolWaitQueueExitedEvent event) {
//                waitQueue.decrementAndGet();
//
//            }
//
//            @Override
//            public void connectionAdded(ConnectionAddedEvent event) {
//                connect.incrementAndGet();
//            }
//
//            @Override
//            public void connectionRemoved(ConnectionRemovedEvent event) {
//                connect.decrementAndGet();
//            }
//        });
//        return builder.build();
//    }

//    @Bean
//    @Primary
//    public MongoTemplate mongoTemplate(MongoClient mongo, MongoMappingContext mongoMappingContext) throws Exception {
//        SimpleMongoClientDatabaseFactory mongoDbFactory = new SimpleMongoClientDatabaseFactory(mongo, database);
//        System.out.println("tenantdb...." + mongoDbFactory.getMongoDatabase().getName());
//        return new MongoTemplate(mongoDbFactory);
//    }

}
