package com.digiwin.athena.kmservice.neo4j;

import org.neo4j.driver.v1.AuthTokens;
import org.neo4j.driver.v1.Config;
import org.neo4j.driver.v1.GraphDatabase;
import org.neo4j.ogm.driver.Driver;
import org.neo4j.ogm.drivers.bolt.driver.BoltDriver;
import org.neo4j.ogm.session.SessionFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigurationPackages;
import org.springframework.boot.autoconfigure.data.neo4j.Neo4jProperties;
import org.springframework.boot.autoconfigure.domain.EntityScanPackages;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.Primary;
import org.springframework.data.neo4j.transaction.Neo4jTransactionManager;

import java.util.List;
import java.util.concurrent.TimeUnit;

/**
 * @program: codes
 * @description: 描述
 * @author: Tuo
 * @create: 2022-07-07 15:47
 **/
@Configuration
@Import({Neo4jProperties.class})
public class Neo4jConfiguration {

    @Autowired
    Neo4jProperties neo4jProperties;

    @Primary
    @Bean("neo4jDriver")
    public org.neo4j.driver.v1.Driver neo4jDriver() {
        System.out.println("neo4jDriver... url=" + neo4jProperties.getUri() + ",username=" + neo4jProperties.getUsername() + ",password=" + neo4jProperties.getPassword());

        Config config = Config.build()
                .withConnectionTimeout(10, TimeUnit.SECONDS)
                .withConnectionLivenessCheckTimeout(2, TimeUnit.MINUTES)
                .withMaxConnectionLifetime(4, TimeUnit.MINUTES)
                .withMaxConnectionPoolSize(50)
                .withConnectionAcquisitionTimeout(1, TimeUnit.MINUTES)
                .toConfig();
        return GraphDatabase.driver(neo4jProperties.getUri(), AuthTokens.basic(neo4jProperties.getUsername(), neo4jProperties.getPassword()), config);
    }

    @Primary
    @Bean("ogmDriver")
    public Driver ogmDriver() {
        Driver ogmDriver = new BoltDriver(neo4jDriver());
        return ogmDriver;
    }

    @Primary
    @Bean
    public SessionFactory sessionFactory(ApplicationContext applicationContext) {
        String[] packages = getPackagesToScan(applicationContext);
        return new SessionFactory(ogmDriver(), packages);
    }

    private String[] getPackagesToScan(ApplicationContext applicationContext) {
        List<String> packages = EntityScanPackages.get(applicationContext)
                .getPackageNames();
        if (packages.isEmpty() && AutoConfigurationPackages.has(applicationContext)) {
            packages = AutoConfigurationPackages.get(applicationContext);
        }
        return org.springframework.util.StringUtils.toStringArray(packages);
    }

    @Primary
    @Bean
    public Neo4jTransactionManager transactionManager(ApplicationContext applicationContext) {
        System.out.println("==========neo4jTransactionManager==========");
        return new Neo4jTransactionManager(sessionFactory(applicationContext));
    }

}
