package com.digiwin.athena.idrive.neo4j;

import com.alibaba.fastjson.JSONPath;
import org.neo4j.driver.Value;
import org.neo4j.driver.internal.value.StringValue;
import org.springframework.data.neo4j.core.convert.Neo4jConversionService;
import org.springframework.data.neo4j.core.convert.Neo4jPersistentPropertyToMapConverter;
import org.springframework.stereotype.Component;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

@Component("myNeo4jPropertiesConverter")
public class MyNeo4jPersistentPropertyToMapConverter implements Neo4jPersistentPropertyToMapConverter<String, Map<String, Map<String,String>>> {




    public static void main(String[] args) {
        Map<String, Map<String,String>> lang1 =new HashMap<>();
        Map<String,String> namelang2 = new HashMap<>();
        namelang2.put("zh_CN","名称1");
        namelang2.put("zh_TW","名称2");
        lang1.put("name",namelang2);

        Map<String, Map<String,String>> lang2 =new HashMap<>();
        JSONPath.set(lang2,"name.en_US","Request PO");
        JSONPath.set(lang2,"name.zh_TW","採購發起");
        System.out.println(lang2);
    }


    @Override
    public Map<String, Value> decompose(Map<String, Map<String, String>> property, Neo4jConversionService neo4jConversionService) {
        Map<String, Value> map = new HashMap<>();
        property.forEach((k,v)->{
            v.forEach((k1,v1)->{
                String fullKey = k+"."+k1;
                map.put(fullKey,new StringValue(v1));
            });
        });
        return map;
    }

    @Override
    public Map<String, Map<String, String>> compose(Map<String, Value> source, Neo4jConversionService neo4jConversionService) {
        System.out.println("compose:"+source);
        if(null==source){return null;}
        Map<String, Map<String,String>> lang = new HashMap<>();
        try {
            source.forEach((k,v)->{
                System.out.println(k.getClass()+":"+v.getClass());
                String path = k;
                JSONPath.set(lang,path,v.asString());
            });
        } catch (Exception e) {
            e.printStackTrace();
        }

        return lang;
    }
}
