package com.digiwin.athena.idrive.neo4j;


import org.neo4j.driver.AuthTokens;
import org.neo4j.driver.Config;
import org.neo4j.driver.GraphDatabase;
import org.neo4j.ogm.driver.Driver;
import org.neo4j.ogm.drivers.bolt.driver.BoltDriver;
import org.neo4j.ogm.session.SessionFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigurationPackages;
import org.springframework.boot.autoconfigure.domain.EntityScanPackages;
import org.springframework.boot.autoconfigure.neo4j.Neo4jProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.data.neo4j.core.Neo4jClient;
import org.springframework.data.neo4j.core.Neo4jTemplate;
import org.springframework.data.neo4j.core.transaction.Neo4jTransactionManager;


import java.util.List;
import java.util.concurrent.TimeUnit;

/**
 * @program: codes
 * @description: 描述
 * @author: Tuo
 * @create: 2022-07-07 15:47
 **/
@Configuration
//@Import({Neo4jProperties.class})
public class Neo4jConfiguration {

    @Autowired
    Neo4jProperties neo4jProperties;


    @Primary
    @Bean("neo4jDriver")
    public org.neo4j.driver.Driver neo4jDriver() {

        Config config = Config.builder()
                .withConnectionTimeout(10, TimeUnit.SECONDS)
                .withConnectionLivenessCheckTimeout(2, TimeUnit.MINUTES)
                .withMaxConnectionLifetime(4, TimeUnit.MINUTES)
                .withMaxConnectionPoolSize(20)
                .withConnectionAcquisitionTimeout(1, TimeUnit.MINUTES)
                .build();
        return GraphDatabase.driver(neo4jProperties.getUri(), AuthTokens.basic(neo4jProperties.getAuthentication().getUsername(), neo4jProperties.getAuthentication().getPassword()), config);
    }

    @Primary
    @Bean
    public Neo4jClient neo4jClient(org.neo4j.driver.Driver  driver){
        return Neo4jClient.create(driver);
    }


    @Primary
    @Bean("ogmDriver")
    public Driver ogmDriver() {
        Driver ogmDriver = new BoltDriver(neo4jDriver());
        return ogmDriver;
    }

    @Primary
    @Bean
    public SessionFactory sessionFactory(ApplicationContext applicationContext) {
        String[] packages = getPackagesToScan(applicationContext);
        return new SessionFactory(ogmDriver(), packages);
    }

    private String[] getPackagesToScan(ApplicationContext applicationContext) {
        List<String> packages = EntityScanPackages.get(applicationContext)
                .getPackageNames();
        if (packages.isEmpty() && AutoConfigurationPackages.has(applicationContext)) {
            packages = AutoConfigurationPackages.get(applicationContext);
        }
        return org.springframework.util.StringUtils.toStringArray(packages);
    }

    @Primary
    @Bean("neo4jTransactionManager") // <3>
    public Neo4jTransactionManager neo4jTransactionManager(ApplicationContext applicationContext) {
        return new Neo4jTransactionManager(neo4jDriver());
    }
    @Primary
    @Bean
    public Neo4jTemplate neo4jTemplate(Neo4jClient client){

        return new Neo4jTemplate(client);
    }

}
