package com.digiwin.athena.idrive.neo4j;

import lombok.Getter;
import lombok.Setter;
import org.neo4j.driver.AuthTokens;
import org.neo4j.driver.Config;
import org.neo4j.driver.GraphDatabase;
import org.neo4j.ogm.driver.Driver;
import org.neo4j.ogm.drivers.bolt.driver.BoltDriver;
import org.neo4j.ogm.session.SessionFactory;
import org.springframework.boot.autoconfigure.AutoConfigurationPackages;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.domain.EntityScanPackages;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.neo4j.core.Neo4jClient;
import org.springframework.data.neo4j.core.Neo4jTemplate;
import org.springframework.data.neo4j.core.transaction.Neo4jTransactionManager;

import java.util.List;
import java.util.concurrent.TimeUnit;

@Configuration
@ConditionalOnProperty(value = "spring.data.neo4j.domain2.enable", havingValue = "true")
//@EnableNeo4jRepositories(transactionManagerRef = Neo4j2Config.TRANSACTION_MANAGER,neo4jTemplateRef = Neo4j2Config.NEO4JTEMPLATE)
@ConfigurationProperties(prefix = "spring.data.neo4j.domain2")
@Setter
@Getter
public class Neo4j2Config {

    {
        System.out.println("Neo4j2Config........");
    }
    public static final String NEO4JTEMPLATE = "NEO4JTEMPLATEDOMIAN2";
    public static final String SESSION_FACTORY = "sessionFactoryFordomain2";
    public static final String TRANSACTION_MANAGER = "transactionManagerFordomain2";

    private String uri;

    private String username;

    private String password;

    private Boolean enable;

    @Bean("neo4jDriverdomain2")
    public org.neo4j.driver.Driver neo4jDriverdomain2() {
        System.out.println("neo4jDriverdomain2... url=" + this.uri + ",username=" + this.username + ",password=" + this.password);

        Config config = Config.builder()
                .withConnectionTimeout(10, TimeUnit.SECONDS)
                .withConnectionLivenessCheckTimeout(2, TimeUnit.MINUTES)
                .withMaxConnectionLifetime(4, TimeUnit.MINUTES)
                .withMaxConnectionPoolSize(20)
                .withConnectionAcquisitionTimeout(1, TimeUnit.MINUTES)
                .build();
        return GraphDatabase.driver(this.uri, AuthTokens.basic(this.username, this.password), config);
    }

    @Bean("ogmDriverdomain2")
    public Driver ogmDriverdomain2() {
        Driver ogmDriver = new BoltDriver(neo4jDriverdomain2());
        return ogmDriver;
    }

    @Bean(name = SESSION_FACTORY)
    public SessionFactory sessionFactory(ApplicationContext applicationContext) {
        String[] packages = getPackagesToScan(applicationContext);
        return new SessionFactory(ogmDriverdomain2(), packages);
    }

    @Bean(NEO4JTEMPLATE)
    public Neo4jTemplate neo4jTemplate1(){

        return new Neo4jTemplate(Neo4jClient.create(neo4jDriverdomain2()));

    }

    @Bean(name = TRANSACTION_MANAGER) // <3>
    public Neo4jTransactionManager neo4jTransactionManager(ApplicationContext applicationContext) {
        System.out.println("==========neo4jTransactionManager1==========");
        return new Neo4jTransactionManager(neo4jDriverdomain2());
    }

    private String[] getPackagesToScan(ApplicationContext applicationContext) {
        List<String> packages = EntityScanPackages.get(applicationContext)
                .getPackageNames();
        if (packages.isEmpty() && AutoConfigurationPackages.has(applicationContext)) {
            packages = AutoConfigurationPackages.get(applicationContext);
        }
        return org.springframework.util.StringUtils.toStringArray(packages);
    }
}
