/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.idrive.neo4j;

import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.neo4j.driver.AuthToken;
import org.neo4j.driver.AuthTokens;
import org.neo4j.driver.Config;
import org.neo4j.driver.Driver;
import org.neo4j.driver.GraphDatabase;
import org.neo4j.ogm.drivers.bolt.driver.BoltDriver;
import org.neo4j.ogm.session.SessionFactory;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.boot.autoconfigure.AutoConfigurationPackages;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.domain.EntityScanPackages;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.neo4j.core.Neo4jClient;
import org.springframework.data.neo4j.core.Neo4jTemplate;
import org.springframework.util.StringUtils;

@Configuration
@ConditionalOnProperty(value={"spring.data.neo4j.domain2.enable"}, havingValue="true")
@ConfigurationProperties(prefix="spring.data.neo4j.domain2")
public class Neo4j2Config {
    public static final String NEO4JTEMPLATE = "NEO4JTEMPLATEDOMIAN2";
    public static final String SESSION_FACTORY = "sessionFactoryFordomain2";
    public static final String TRANSACTION_MANAGER = "transactionManagerFordomain2";
    private String uri;
    private String username;
    private String password;
    private Boolean enable;

    public Neo4j2Config() {
        System.out.println("Neo4j2Config........");
    }

    @Bean(value={"neo4jDriverdomain2"})
    public Driver neo4jDriverdomain2() {
        System.out.println("neo4jDriverdomain2... url=" + this.uri + ",username=" + this.username + ",password=" + this.password);
        Config config = Config.builder().withConnectionTimeout(10L, TimeUnit.SECONDS).withConnectionLivenessCheckTimeout(2L, TimeUnit.MINUTES).withMaxConnectionLifetime(4L, TimeUnit.MINUTES).withMaxConnectionPoolSize(20).withConnectionAcquisitionTimeout(1L, TimeUnit.MINUTES).build();
        return GraphDatabase.driver((String)this.uri, (AuthToken)AuthTokens.basic((String)this.username, (String)this.password), (Config)config);
    }

    @Bean(value={"ogmDriverdomain2"})
    public org.neo4j.ogm.driver.Driver ogmDriverdomain2() {
        BoltDriver ogmDriver = new BoltDriver(this.neo4jDriverdomain2());
        return ogmDriver;
    }

    @Bean(name={"sessionFactoryFordomain2"})
    public SessionFactory sessionFactory(ApplicationContext applicationContext) {
        String[] packages = this.getPackagesToScan(applicationContext);
        return new SessionFactory(this.ogmDriverdomain2(), packages);
    }

    @Bean(value={"NEO4JTEMPLATEDOMIAN2"})
    public Neo4jTemplate neo4jTemplate1() {
        return new Neo4jTemplate(Neo4jClient.create((Driver)this.neo4jDriverdomain2()));
    }

    private String[] getPackagesToScan(ApplicationContext applicationContext) {
        List packages = EntityScanPackages.get((BeanFactory)applicationContext).getPackageNames();
        if (packages.isEmpty() && AutoConfigurationPackages.has((BeanFactory)applicationContext)) {
            packages = AutoConfigurationPackages.get((BeanFactory)applicationContext);
        }
        return StringUtils.toStringArray((Collection)packages);
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setEnable(Boolean enable) {
        this.enable = enable;
    }

    public String getUri() {
        return this.uri;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public Boolean getEnable() {
        return this.enable;
    }
}

