/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.idrive.neo4j;

import java.net.URI;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.neo4j.driver.AuthToken;
import org.neo4j.driver.AuthTokens;
import org.neo4j.driver.Config;
import org.neo4j.driver.Driver;
import org.neo4j.driver.GraphDatabase;
import org.neo4j.ogm.drivers.bolt.driver.BoltDriver;
import org.neo4j.ogm.session.SessionFactory;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigurationPackages;
import org.springframework.boot.autoconfigure.domain.EntityScanPackages;
import org.springframework.boot.autoconfigure.neo4j.Neo4jProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.data.neo4j.core.Neo4jClient;
import org.springframework.data.neo4j.core.Neo4jTemplate;
import org.springframework.data.neo4j.core.transaction.Neo4jTransactionManager;
import org.springframework.util.StringUtils;

@Configuration
public class Neo4jConfiguration {
    public static final String NEO4JTransaction = "neo4jTransactionManager";
    public static final String NEO4JTEMPLATE = "DEFAULTNEO4JTEMPLATEDOMIAN";
    @Autowired
    Neo4jProperties neo4jProperties;

    @Primary
    @Bean(value={"neo4jDriver"})
    public Driver neo4jDriver() {
        System.out.println("neo4jDriverdomain... url=" + this.neo4jProperties.getUri() + ",username=" + this.neo4jProperties.getAuthentication().getUsername());
        Config config = Config.builder().withConnectionTimeout(10L, TimeUnit.SECONDS).withConnectionLivenessCheckTimeout(2L, TimeUnit.MINUTES).withMaxConnectionLifetime(4L, TimeUnit.MINUTES).withMaxConnectionPoolSize(20).withConnectionAcquisitionTimeout(1L, TimeUnit.MINUTES).build();
        return GraphDatabase.driver((URI)this.neo4jProperties.getUri(), (AuthToken)AuthTokens.basic((String)this.neo4jProperties.getAuthentication().getUsername(), (String)this.neo4jProperties.getAuthentication().getPassword()), (Config)config);
    }

    @Primary
    @Bean
    public Neo4jClient neo4jClient(Driver driver) {
        return Neo4jClient.create((Driver)driver);
    }

    @Primary
    @Bean(value={"ogmDriver"})
    public org.neo4j.ogm.driver.Driver ogmDriver() {
        BoltDriver ogmDriver = new BoltDriver(this.neo4jDriver());
        return ogmDriver;
    }

    @Primary
    @Bean
    public SessionFactory sessionFactory(ApplicationContext applicationContext) {
        String[] packages = this.getPackagesToScan(applicationContext);
        return new SessionFactory(this.ogmDriver(), packages);
    }

    private String[] getPackagesToScan(ApplicationContext applicationContext) {
        List packages = EntityScanPackages.get((BeanFactory)applicationContext).getPackageNames();
        if (packages.isEmpty() && AutoConfigurationPackages.has((BeanFactory)applicationContext)) {
            packages = AutoConfigurationPackages.get((BeanFactory)applicationContext);
        }
        return StringUtils.toStringArray((Collection)packages);
    }

    @Primary
    @Bean(value={"neo4jTransactionManager"})
    public Neo4jTransactionManager neo4jTransactionManager(ApplicationContext applicationContext) {
        return new Neo4jTransactionManager(this.neo4jDriver());
    }

    @Primary
    @Bean(value={"DEFAULTNEO4JTEMPLATEDOMIAN"})
    public Neo4jTemplate neo4jTemplate(Neo4jClient client) {
        return new Neo4jTemplate(client);
    }
}

