/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.idrive.neo4j;

import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.neo4j.driver.AuthToken;
import org.neo4j.driver.AuthTokens;
import org.neo4j.driver.Config;
import org.neo4j.driver.Driver;
import org.neo4j.driver.GraphDatabase;
import org.neo4j.ogm.drivers.bolt.driver.BoltDriver;
import org.neo4j.ogm.session.SessionFactory;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.boot.autoconfigure.AutoConfigurationPackages;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.domain.EntityScanPackages;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.neo4j.core.Neo4jClient;
import org.springframework.data.neo4j.core.Neo4jTemplate;
import org.springframework.data.neo4j.core.transaction.Neo4jTransactionManager;
import org.springframework.util.StringUtils;

@Configuration
@ConditionalOnProperty(value={"spring.data.neo4j.domain1.enable"}, havingValue="true")
@ConfigurationProperties(prefix="spring.data.neo4j.domain1")
public class Neo4j1Config {
    public static final String NEO4JTEMPLATE = "NEO4JTEMPLATEDOMIAN1";
    public static final String SESSION_FACTORY = "sessionFactoryForDomain1";
    public static final String TRANSACTION_MANAGER = "transactionManagerForDomain1";
    private String uri;
    private String username;
    private String password;
    private Boolean enable;

    public Neo4j1Config() {
        System.out.println("Neo4j1Config........");
    }

    @Bean(value={"neo4jDriverDomain1"})
    public Driver neo4jDriverDomain1() {
        System.out.println("neo4jDriverDomain1... url=" + this.uri + ",username=" + this.username + ",password=" + this.password);
        Config config = Config.builder().withConnectionTimeout(10L, TimeUnit.SECONDS).withConnectionLivenessCheckTimeout(2L, TimeUnit.MINUTES).withMaxConnectionLifetime(4L, TimeUnit.MINUTES).withMaxConnectionPoolSize(20).withConnectionAcquisitionTimeout(1L, TimeUnit.MINUTES).build();
        return GraphDatabase.driver((String)this.uri, (AuthToken)AuthTokens.basic((String)this.username, (String)this.password), (Config)config);
    }

    @Bean(value={"ogmDriverDomain1"})
    public org.neo4j.ogm.driver.Driver ogmDriverDomain1() {
        BoltDriver ogmDriver = new BoltDriver(this.neo4jDriverDomain1());
        return ogmDriver;
    }

    @Bean(name={"sessionFactoryForDomain1"})
    public SessionFactory sessionFactory(ApplicationContext applicationContext) {
        String[] packages = this.getPackagesToScan(applicationContext);
        return new SessionFactory(this.ogmDriverDomain1(), packages);
    }

    @Bean(value={"NEO4JTEMPLATEDOMIAN1"})
    public Neo4jTemplate neo4jTemplate1() {
        return new Neo4jTemplate(Neo4jClient.create((Driver)this.neo4jDriverDomain1()));
    }

    @Bean(name={"transactionManagerForDomain1"})
    public Neo4jTransactionManager neo4jTransactionManager1(ApplicationContext applicationContext) {
        System.out.println("==========neo4jTransactionManager1==========");
        return new Neo4jTransactionManager(this.neo4jDriverDomain1());
    }

    private String[] getPackagesToScan(ApplicationContext applicationContext) {
        List packages = EntityScanPackages.get((BeanFactory)applicationContext).getPackageNames();
        if (packages.isEmpty() && AutoConfigurationPackages.has((BeanFactory)applicationContext)) {
            packages = AutoConfigurationPackages.get((BeanFactory)applicationContext);
        }
        return StringUtils.toStringArray((Collection)packages);
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setEnable(Boolean enable) {
        this.enable = enable;
    }

    public String getUri() {
        return this.uri;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public Boolean getEnable() {
        return this.enable;
    }
}

