package com.digiwin.athena.dto;

import lombok.Data;

import java.util.List;
import java.util.Set;

@Data
public class FieldMeta {

    private String key;
    private String code;
    private String name;
    //当前字段数据类型
    private String dateType;
    //如果当前是集合则表示内部元素类型
    private String innerType;
    //显示类型，如文本框，选择框等
    private String displayType;
    //内部的值
    private Object value;
    //校验规则
    private DataRule rule;
    //表示选择类型的列表
    private List<FieldMeta> options;
    //如果当前是对象这里定义对象的子属性
    private List<FieldMeta> fields;
    //是否是主键
    private Boolean pk;
    //标签用于表述字段的意义 human、price、time等，在如选择一个字段作为执行人的场景可以匹配到标签为human的字段
    private Set<String> tags;

}
