package com.digiwin.athena.mechanism.pre;


import com.digiwin.athena.domain.common.BaseObject;
import com.digiwin.athena.mechanism.pre.parts.*;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import lombok.Data;

import java.util.Map;

/**
 * @program: codes
 * @description: 暂时把子类的所有属性都放到父类上做承载，因为不论是从mongo中读取还是接口传入通过父类来接都会丢失子类数据
 * @author: Tuo
 * @create: 2023-03-08 10:48
 **/
@Data
@JsonTypeInfo(use = JsonTypeInfo.Id.NAME,include = JsonTypeInfo.As.PROPERTY,property = "code",visible=true)
@JsonSubTypes({
        @JsonSubTypes.Type(value = SourceSchedulePart.class,name=MechanismCapacityCodes.sourceSchedule),
        @JsonSubTypes.Type(value = SourceTargetPart.class,name=MechanismCapacityCodes.sourceTask),
        @JsonSubTypes.Type(value = SourceTaskDecisionPart.class,name=MechanismCapacityCodes.sourceTaskDecision),
        @JsonSubTypes.Type(value = SourceTaskDecisionPart.class,name=MechanismCapacityCodes.sourceTaskDecisionObject),
        @JsonSubTypes.Type(value = ActionWarnMessagePart.class,name=MechanismCapacityCodes.actionWarnMessage),
        @JsonSubTypes.Type(value = CheckTaskOnTimeOverPart.class,name=MechanismCapacityCodes.checkTaskOnTimeOver),
        @JsonSubTypes.Type(value = CheckTaskAccordingToStandardPart.class,name=MechanismCapacityCodes.checkTaskAccordingToStandard),
        @JsonSubTypes.Type(value = CheckTaskByQuantityPart.class,name=MechanismCapacityCodes.checkTaskByQuantity),
        @JsonSubTypes.Type(value = LimitSourceTaskPart.class,name=MechanismCapacityCodes.sourceTaskUpdate),
        @JsonSubTypes.Type(value = LimitSourceTaskPart.class,name=MechanismCapacityCodes.sourceDataEntryAdd),
        @JsonSubTypes.Type(value = LimitSourceTaskPart.class,name=MechanismCapacityCodes.sourceTaskInExecution),
        @JsonSubTypes.Type(value = LimitSourceTaskPart.class,name=MechanismCapacityCodes.sourceTaskOpen),
        @JsonSubTypes.Type(value = ActionStartTaskPart.class,name=MechanismCapacityCodes.actionStartTask),
        @JsonSubTypes.Type(value = ActionOptionDecisionPart.class,name=MechanismCapacityCodes.actionOptionDecision),
        @JsonSubTypes.Type(value = SourceAssignPart.class,name=MechanismCapacityCodes.sourceAssign),
        @JsonSubTypes.Type(value = AssignRulePart.class,name=MechanismCapacityCodes.assignDefinition),
        @JsonSubTypes.Type(value = AdvancedAssignRulePart.class,name=MechanismCapacityCodes.advancedAssignDefinition),
        @JsonSubTypes.Type(value = ConditionsPart.class,name=MechanismCapacityCodes.conditions),
        @JsonSubTypes.Type(value = ConditionsPart.class,name=MechanismCapacityCodes.personnelCondition),
        @JsonSubTypes.Type(value = ConditionsPart.class,name=MechanismCapacityCodes.businessCondition),
        @JsonSubTypes.Type(value = ConditionsPart.class,name=MechanismCapacityCodes.apiDataCheckCondition),
        @JsonSubTypes.Type(value = LimitTaskActionPart.class,name=MechanismCapacityCodes.limitTaskAction),
        @JsonSubTypes.Type(value = LimitTaskActionPart.class,name=MechanismCapacityCodes.reminder),
        @JsonSubTypes.Type(value = LimitTaskActionPart.class,name=MechanismCapacityCodes.limitAction),
        @JsonSubTypes.Type(value = LimitTaskActionPart.class,name=MechanismCapacityCodes.autoProcess),
        @JsonSubTypes.Type(value = CheckKeyProcessIntegrationRatePart.class,name=MechanismCapacityCodes.CheckKeyProcessIntegrationRate),
        @JsonSubTypes.Type(value = SourceTaskDecisionForOpenWindowPart.class,name=MechanismCapacityCodes.SourceTaskDecisionForOpenWindow),
        @JsonSubTypes.Type(value = ActionOpenWindowDecisionPart.class,name=MechanismCapacityCodes.ActionOpenWindowDecision),

})
public class MechanismPart extends BaseObject {

    private String code;
    private String name;
    private String type;
    //除零件之外的其他参数
    private Map<String,Object> params;





}
