package com.digiwin.athena.domain.common;

import com.digiwin.athena.domain.definition.FieldDescription;
import lombok.Data;

import java.util.List;

@Data
public class ParamApi {
    /**
     * ESP : 表示调用的是esp的api
     */
    private String from;
    /**
     * 查询api
     */
    private String queryApi;
    /**
     * 新增api
     */
    private String updateApi;
    /**
     * 界面要设置的应用参数，正常来讲参数都能从queryApi的返回中获取，并且updateApi时需要更新对应的参数值
     */
    private List<FieldDescription> paramDescription;
    /**
     * ？？？调用queryApi时的入参，为空时不用参数调用
     */
    private List<FieldDescription> queryRequestParmas;

    /**
     * 参数是否支持运营单元级别，默认false不分区
     */
    private boolean supportOperationUnit;
}
