package com.digiwin.athena.mechanism.bo;

import com.digiwin.athena.mechanism.common.MechanismAbility;
import com.digiwin.athena.mechanism.widgets.action.AutoProcess;
import com.digiwin.athena.mechanism.widgets.action.LimitAction;
import com.digiwin.athena.mechanism.widgets.action.Reminder;
import com.digiwin.athena.mechanism.widgets.choose.SingleStrategyWidget;
import com.digiwin.athena.mechanism.widgets.condition.BusinessCondition;
import com.digiwin.athena.mechanism.widgets.condition.PersonnelCondition;
import lombok.Data;

import java.util.List;

/**
 * @program: codes
 * @description: 描述
 * @author: Tuo
 * @create: 2022-07-28 08:51
 **/
@Data
public class LimitAbilityBo extends MechanismAbility {

    private List<SingleStrategyWidget> strategies;

    /**
     * 触发条件code
     */
    private String conditionCode;

    /**
     * 限制行动code
     */
    private String actionCode;

    /**
     * 触发条件 - 业务条件
     */
    private BusinessCondition businessCondition;

    /**
     * 触发条件 - 人员条件
     */
    private PersonnelCondition personnelCondition;

    /**
     * 限制的行动 - 提示画面
     */
    private Reminder reminder;

    /**
     * 限制的行动 - 任务执行
     */
    private LimitAction limitAction;

    /**
     * 限制的行动 - 自动处理
     */
    private AutoProcess autoProcess;

    /**
     * pageUIElement表code
     */
    private String dataViewCode;

}
