package com.digiwin.athena.mechanism.pre;


import com.digiwin.athena.domain.common.TenantObject;
import com.digiwin.athena.mechanism.vo.LinkInfo;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;
import java.util.List;

/**
机制能力设计时模型，会转换为机制能力
 **/

@Data
public class MechanismCapacity extends TenantObject {

    private String mechanismCode;
    private String mechanismVersion;
    private String mechanismTheoryCode;

    //机制决策MechanismDecision,
    //机制控制MechanismControl,
    //机制限制MechanismLimit,
    //机制指派MechanismAssign,
    //机制驱动MechanismDrive,
    private String type;

    //0草稿 1发布
    private Integer status;

    //能力注册的机制参数
    private List<String> registerParams;

    private MechanismPart source;

    private MechanismPart check;

    private MechanismPart action;
    //限制能力-条件
    private MechanismPart condition;

//    //指派源 改为source
//    private MechanismPart assignSource;
//    //指派规则  改为action
//    private MechanismPart assignRule;

    @JsonFormat(timezone = "GMT+8",pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    private Date createTime;

    /**
     * 来自开发平台的设计时间
     */
    private Date createDate;

    //能力是否已经实际应用生效
    private Boolean hasApply;

    private String  from;

    /**
     * 标识创建自开发平台
     */
    private boolean createdByDevPlatform;

    /**
     * 标识该租户级能力对应的系统级能力已经被开发平台删除
     */
    private boolean deletedByDevPlatform;

    //连接参数
    private List<LinkInfo> links;

    //允许被查询到的机制参数 需要创建一个能力后  再手动入表关联一个机制参数  才能被选择
    private List<LinkInfo> mechanismLink;

}
