package com.digiwin.athena.domain.core.process;

import lombok.Data;

/**
 * 数据节点-字段属性
 */
@Data
public class FiledInfo {

    /**
     * key字段类型(varchar...)
     */
    private String fieldType;

    /**
     * key编码
     */
    private String fieldId;

    /**
     * key是否为必填项
     */
    private Boolean isRequired = false;

    /**
     * key全链路
     */
    private String fullPath;

    /**
     * value类别
     * 常量:constant,变量:variable
     */
    private String paramType = "constant";

    /**
     * value名称
     */
    private String valueName;

    /**
     * value编码（表+字段属性）
     */
    private String fieldValue;

    /**
     * 字段value属性
     * 模型字段:modelVariable  流程字段:processVariable
     */
    private String valueType;

    /**
     * 模型的数据目标来源(表) - 模型变量
     */
    private String modelCode;

    /**
     * 模型的数据目标来源(库) -模型变量
     */
    private String serviceCode;

    /**
     * 模型数据目标来源(节点) -模型变量
     */
    private String nodeId;

    /**
     * 自定义变量code
     */
    private String variableCode;

    /**
     * 模型数据所属节点类型(节点) - 模型变量
     */
    private String noteType;

    /**
     * 数据节点子类型 - 模型变量
     */
    private String noteSubType;

    /**
     * 后缀
     */
    private String valueSuffix;
}
