package com.digiwin.athena.mechanism.common;

import lombok.extern.slf4j.Slf4j;

import java.util.Objects;

/**
 * @title: AttachmentType
 * @description: AttachmentType
 * @author: linc
 * @date 2023/3/23 18:31
 * @version: 1.0
 */
@Slf4j
public enum AttachmentType {
    DMC(0,"DMC"),
    OUTER(1,"OUTER"),
    ERP(2,"ERP");

    private final Integer type;

    private final String value;

    AttachmentType(Integer type,String value) {
        this.type = type;
        this.value = value;
    }

    private Integer type() {
        return this.type;
    }

    private String value() {
        return this.value;
    }

    public static String getValue(Integer type) {
        AttachmentType[] attachmentTypes = values();
        for (AttachmentType attachmentType : attachmentTypes) {
            if (Objects.equals(attachmentType.type(),type)) {
                return attachmentType.value();
            }
        }
        log.info("call AttachmentType.getValue input type:{}",type);
        return null;
    }

}
