package com.digiwin.athena.domain.component.bo;


import lombok.Data;
import org.springframework.data.mongodb.core.mapping.Document;

import java.util.List;


@Data
@Document(collection = "componentStructuredList")
public class ComponentStructuredListBO {

    //结构清单类型
    private ComponentStructuredListType type;
    //应用编号，同时也是管理议题编号
    private String appCode;
    //范式，对应客户在特定管理议题下的分类
    private String paradigm;
    //机制编号
    private String mechanismCode;
    //组件结构版本号，为将来可能发生的结构变化提供兼容方案，每个版本可以用不同的解析器进行解析
    private String structureVersion;
    //开发成果版本号
    private String version;

    //组件
    private List<StructuredComponentBO> components;
}
