package com.digiwin.athena.domain.core.process;

import lombok.Data;

import java.util.List;
import java.util.Map;

@Data
public class ActionConfig {

    /**
     * 服务类型
     * ESP/HTTP/SCRIPT/MODEL_UPDATE
     */
    private String type;

    /**
     * http使用
     */
    private String domain;

    /**
     * http使用
     */
    private String url;

    /**
     * http使用
     * GET | POST
     */
    private String method;

    /**
     * 产品名 ESP用
     */
    private String prod;

    /**
     * ESP使用
     * 是否为异步 true=异步;false 同步
     */
    private Boolean isAsync = false;

    /**
     * esp
     * esp服务名称或者API路径，若选择default则需输入全路路径
     */
    private String serviceName;

    /**
     * esp和http使用
     * json 字符串 k-v 格式
     */
    private Map<String, String> header;

    /**
     * 请求脚本，返回json对象。esp和http使用
     */
    private String requestScript;

    /**
     * 响应脚本，返回json对象。
     * esp、http、script使用，script只有响应脚本
     */
    private String responseScript;

    /**
     * 界面绑定的模型信息 - MODEL_UPDATE
     */
    private Map<String, Object> bindForm;

    /**
     * 赋值信息 - MODEL_UPDATE
     */
    private List<FiledInfo> fieldInfos;
}
