package com.digiwin.athena.domain.core.process;

import lombok.Data;

/**
 * @description 预计完成日配置对象
 * @author wujiang@digiwin.com
 * @param[1] null
 * @time 2024/9/26 19:29
 */
@Data
public class PlanEndTimeDefinition {

    /**
     *配置类型：
     * calculation - 计算到期日
     * specify-指定到期日
     * no-不启用预完日
     */
    private String settingType;

    /**
     *来源：constant：常量；variable：变量
     */
    private String sourceType;

    /**
     * 时间类型 时间类型 分钟、小时、天、周
     *               minute/hour/day/week
     */
    private String dateType;

    /**
     * dataType 对应的时间，例如1天后、1周后
     */
    private String dateValue;

    /**
     * 值： sourceType= constant ：必须是日期格式
     *    sourceType = variable ： $varibale[variableKey].endTime
     */
    private String sourceValue;

    /**
     *sourceType = variable 时候必填 变量的类型 modelVariable systemVariable customVariable businessObjectVariable 等
     */
    private String variableType;

    /**
     * sourceType = variable 时候必填
     */
    private String variableCode;

    /**
     *sourceType = variable 时候必填
     */
    private String variablePath;

    /**
     *sourceType = variable 时候必填
     */
    private String variableSuffix;


}