package com.digiwin.athena.domain.core.process;

import com.digiwin.athena.domain.common.TenantObject;
import lombok.Getter;
import lombok.Setter;
import org.springframework.data.mongodb.core.mapping.Document;

import java.util.List;
import java.util.Map;

/**
 * @author yueyyc
 * @version 1.0
 * @date 2023/12/11 15:45
 */
@Setter
@Getter
@Document(collection = "process")
public class Process extends TenantObject {
    //自动生成  Process_UUID
    private String processId;
    private String processName;
    //类型， 默认 1=审批流；2=业务流；3=服务编排
    private Integer processType;
    //1草稿，2发布，3生效，4失效
    private Integer status;
    private String businessCode;
    private String businessName;
    private Integer designVersion;
    private Integer processVersion;// 流程版本，每次发布需进版发布,修改名字避免平台version冲突
    // 默认项目code同流程id
    private String projectCode;
    private Map<String, String> limitConfig;

    //支持交付设计器设置
    private Boolean isDesignerSet;
    // 节点信息和线信息
    private ProcessConfig processConfig;
    // 流程设置->节点预设置  绑定全局界面
    private Map<String, Object> bindForm;
    private List<Map<String, String>> events;
    //page界面触发、monitorRule定时触发、event事件触发、project手动发起项目
    private String triggerType;
    private ProcessTriggerConfig triggerConfig;
    //画布数据
    private ProcessFlowGraph flowGraph;


    // 返回的流程路径
    private String processPath;

    private Boolean publishFlag = false;

    private Long publishTime;

    // 流程所在业务对象的模型code
    private String businessModelCode;
    // 流程所在业务对象的模型code
    private String businessServiceCode;

    /**
     * 租户级数据
     */
    private List<PublishTenantInfo> adpTenantList;

    /**
     * 租户级流程Id-用于租户级开发平台
     */
    private String tenantProcessId;

    /**
     * 项目卡合并 true/false
     */
    private Boolean merge;

    /**
     * 项目时距
     */
    private DueDateTimeDistance dueDateTimeDistance;

    /**
     * 合并字段名数组
     */
    private List<String> mergeFields;


    /**
     * 流程属性-自定义变量
     */
    private List<CustomVariable> customVariables;

    /**
     * 流程属性-系统变量
     */
    private List<CustomVariable> systemVariable;

    /**
     * 流程属性-业务对象变量
     */
    private List<CustomVariable> businessObjectVariables;

    /**
     * 流程属性-机制参数变量
     */
    private List<CustomVariable> mechanismVariables;

    /**
     * 流程属性-dtd参数变量
     */
    private List<CustomVariable> dtdVariable;

    /**
     * 编译后-流程变量的存贮 存在默认值
     */
    private Map<String, Object> customVariable;

    /**
     * 必填属性填写
     */
    private Map<String, Object> requiredVariables;

    private String adpKmDeployId;

    private String addSourceType;

    /**
     * 流程版本号
     */
    private String adpVersion;

    /**
     * 备注序列号
     */
    private Integer adpRemarkNumber;

    /**
     * 流程多版本-状态 - 多版本状态中只有一个处于运行态,其他都是设计态
     */
    private String adpStatus = ProcessVersionStatusEnum.DESIGN_STATE.getCode();


    /**
     * 预完日字段配置
     */
    private PlanEndTimeDefinition planEndTime;

    public Process() {
    }

    public Process(String businessCode, String triggerType, Integer status, String processName, String applicationName) {
        this.status = status;
        this.businessCode = businessCode;
        this.triggerType = triggerType;
        this.processName = processName;

        super.setApplication(applicationName);
    }



    /**
     * 大T添加=workflowTask
     */
    private String adpType;

    /**
     * 大T添加
     */
    private String taskCode;

}
