package com.digiwin.athena.domain.core.view;


import com.digiwin.athena.domain.common.TenantObject;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import org.springframework.data.mongodb.core.index.CompoundIndex;
import org.springframework.data.mongodb.core.index.CompoundIndexes;
import org.springframework.data.mongodb.core.mapping.Document;

import java.util.Map;

@Getter
@Setter
@EqualsAndHashCode(callSuper = true)
@Document(collection = "pageUIElement")
@CompoundIndexes({
        @CompoundIndex(name = "key_index", def = "{'code':1, 'activityId':1,'pageCode':1}", background = true),
        @CompoundIndex(name = "key_tenantId", def = "{'tenantId':1}", background = true)}
)
public class PageUIElement extends TenantObject {
    /**
     * dataView.code  查询方案code
     */

    /**
     * =dm.task.code  =kg.activityConfig.code
     */
    private String activityId;
    /**
     * 项目(project-detail-waitting/project-detail-tracking/project-detail-completed)
     * 任务(task-detail-waitting/task-detail-tracking/task-detail-completed)
     * 作业浏览界面(browse-page)
     * 编辑界面(edit-page)
     * 子页面（sub-page）
     */
    private String pageCode;
    /**
     * "layout": [],
     * "operations": [],
     * "submitActions": [],
     * "hooks": [],
     * "gridSettings": []
     */
    private Map<String, Object> elements;


}


