package com.digiwin.athena.domain.customBizTask;

import com.digiwin.athena.domain.core.dtdflow.CustBizTask;
import lombok.Data;
import org.springframework.data.mongodb.core.mapping.Document;

import java.util.List;

/**
 * 业务流自定义配置实体类
 */
@Data
@Document(collection = "customBizTaskConfig")
public class CustBizTaskConfigDTO {
	/**
	 * 业务流自定义配置code,customBizTaskConfig表的code
	 */
	private String code;
	/**
	 * 项目code
	 */
	private String projectCode;
	/**
	 * 是否允许特定场景业务流自定义
	 */
	private Boolean customGroupSkip = Boolean.FALSE;
	/**
	 * 业务流
	 */
	private List<CustBizTask> bizTasks;
	/**
	 * 特定场景业务流自定义配置
	 */
	private List<CustConfigGroupSkip> groupSkipConfig;
	/**
	 * 租户id
	 */
	private String tenantId;
	/**
	 * 版本号
	 */
	private String version;
}

