package com.digiwin.athena.domain.log;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.springframework.data.mongodb.core.index.CompoundIndex;
import org.springframework.data.mongodb.core.index.CompoundIndexes;
import org.springframework.data.mongodb.core.mapping.Document;

/**
 * @author tang jie cheng
 * @date 2023-11-09 13:44
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@Builder
@Document(collection = "operationRecord")
@CompoundIndexes({@CompoundIndex(name = "key_idx", def = "{'type':1, 'tenantId':1}")})
public class OperationRecord {
    /**
     * 操作行为
     */
    private String type;
    /**
     * 操作类/方法路径
     */
    private String path;


    @Builder.Default
    private String userId = "000000";

    @Builder.Default
    private String tenantId = "SYSTEM";

    private Object supplementaryContent;

    private String application;

    private String time;
}
