package com.digiwin.athena.kg.activity;

import com.digiwin.athena.domain.definition.Identity;
import com.digiwin.athena.kg.domain.DomainEntity;

import lombok.Data;

import java.util.List;

/**
 * @program: athena_backend
 * @description: 描述
 * @author: Tuo
 * @create: 2021-05-08 16:07
 **/
@Data
public class ApproveInfo extends DomainEntity {

    public static final String SEQ="sequence";
    public static final String DEC="decision";


    //模板id，全局唯一
    private String templateId;
    private String templateName;
    //Y-需签核；N-无需签核
    private String enableApprove;
    private Boolean needEnableApprove;
    //Y-可修改数据；N-可修改数据
    private String enableModify;
    //sequence|decision
    private String type;
    //发起者 (在核决流程中也作为基础人)
    private ApproveInitiator initiator;
    private ApproveDecision decision;
    private List<ApproveSequenceItem> sequence;

    //顺序签是否跳过连续相同的人 1表示启用 0不起用
    private String sequenceRepeatActSkip;

    private List<Identity> presetVariables;


}
