package com.digiwin.athena.kg.activity;


import com.digiwin.athena.domain.definition.times.DueDateRule;

public class ExpectedDurationDTO implements Cloneable {

    private DurationTypeEnum type;

    private int value;
    //0或者null取value的值表示时距,1表示获取api指定时间通过dueDateRule获取数据, 2表示常量值 对应constantValue
    private Integer dueDateType;

    private DueDateRule dueDateRule;

    public DurationTypeEnum getType() {
        return type;
    }

    public void setType(DurationTypeEnum type) {
        this.type = type;
    }

    public int getValue() {
        return value;
    }

    public void setValue(int value) {
        this.value = value;
    }

    public Integer getDueDateType() {
        return dueDateType;
    }

    public void setDueDateType(Integer dueDateType) {
        this.dueDateType = dueDateType;
    }

    public DueDateRule getDueDateRule() {
        return dueDateRule;
    }

    public void setDueDateRule(DueDateRule dueDateRule) {
        this.dueDateRule = dueDateRule;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        ExpectedDurationDTO expectedDurationDTO = (ExpectedDurationDTO) super.clone();
        DueDateRule dueDateRule = expectedDurationDTO.getDueDateRule();
        if (dueDateRule != null) {
            expectedDurationDTO.setDueDateRule((DueDateRule)dueDateRule.clone());
        }
        return expectedDurationDTO;
    }

    //常量值
    private String constantValue;

    public void setConstantValue(String constantValue) {
        this.constantValue = constantValue;
    }

    public String getConstantValue() {
        return this.constantValue;
    }
}
