package com.digiwin.athena.mechanism.bo;


import com.digiwin.athena.domain.common.BaseObject;
import lombok.Data;
import lombok.experimental.Accessors;
import org.springframework.data.mongodb.core.mapping.Document;

/**
 * @Description
 * @Author liugl
 * @Date 2024/6/26 9:13
 **/
@Data
@Accessors(chain = true)
@Document(collection = "mechanismFunction")
public class MechanismFunctionBO extends BaseObject {
	/**
	 * 主键id
	 */
	private String id;
	/**
	 * 唯一键
	 */
	private String code;
	/**
	 * 自定义函数名称
	 */
	private String name;
	/**
	 * 项目code
	 */
	private String projectCode;
	/**
	 * 任务code
	 */
	private String taskCode;
	/**
	 * 操作字段code。如果是对关联表内的字段做操作，则父级code.子级code
	 */
	private String fieldCode;

	/**
	 * 操作字段对象
	 */
	private Object field;
	/**
	 * 机制类型
	 */
	private String mechanismType;
	/**
	 * 输入类型
	 */
	private String inputType;
	/**
	 * 输出类型
	 */
	private String outputType;
	/**
	 * 字段路径
	 */
	private String path;
	/**
	 * 自定义函数中的基础函数
	 */
	private String function;
	/**
	 * 是否为预置函数
	 */
	private Boolean isPreset;
	/**
	 * 说明
	 */
	private String description;
	/**
	 * 用法
	 */
	private String usage;

	/**
	 * 自定义函数比较值
	 */
	private Object functionValue;
}
