package com.digiwin.athena.mechanism.common;


import com.digiwin.athena.dto.MultiLanguageDTO;
import com.digiwin.athena.mechanism.bo.MechanismFunctionBO;
import lombok.Data;
import lombok.experimental.Accessors;

/**
 * @program: codes
 * @description: 描述
 * @author: Tuo
 * @create: 2022-07-06 20:18
 **/
@Data
@Accessors(chain = true)
public class MechanismVariable {

    private String name;
    private String code;
    private Object value;
    private String data_name;
    private String data_type;
    private String required;
    private String is_datakey;
    private Boolean is_array;
    private Boolean is_businesskey;
    private String fullPath;
    private String path;
    //20220515 by maxl
    //增加枚举key，对应到词条枚举值dictionary的key
    private String enum_key;
    private String format;
    private Boolean is_function;
    //是否遍历数组中所有元素： 0 或者 null不遍历 ，1 遍历取数组中元素
    private Integer foreach_array;
    private String unit;
    private String type;
    //page页面元数据，dtd后台数据，用于机制中页面选择任务元数据表示入口是哪个
    private String rootNode;

    //currentDay currentWeek currentMonth
    private String currentType;
    private MechanismVariable from;
    private MechanismVariable to;
    private String opType;
    private int index = 0;
    private String column;
    /**
     * 自定义函数类
     */
    private MechanismFunctionBO mechanismFunction;
    private Object functionValue;
    private String functionValueType;
    private MultiLanguageDTO descriptionLang;
    /*******************机制参数相关************************/
    //Api返回的每个action对应的request_parameters
    //中的data_name字段的值
    private String configItem;
    //（Customize：自定义，MechanismParameters：机制参数）
    private String configType;
    /*******************机制参数相关************************/


    public String wrapperedPath(){
        if(Boolean.TRUE.equals(is_function)){return path;}
        return wrapperPath(this.getPath(),this.getData_type());
    }

    public static String wrapperPath(String path,String type){
        if(null==path){return null;}

        if(!path.startsWith("$")){
            int index = path.indexOf(".");
            String first = null;
            String rest=null;
            if(index>0){
                first = path.substring(0,index);
                rest = path.substring(index);
            }else{
                first = path;
                rest = "";
            }
            if(first.contains("[")){
                int index2 = first.indexOf("[");
                String first1 = first.substring(0,index2);
                String rest1 = first.substring(index2);
                first = first1;
                rest = rest1+rest;
            }

            if(rest.isEmpty() && "string".equalsIgnoreCase(type)){
                path = "\"$("+first+")\"";
            }else{
                path = "$("+first+")"+rest;
            }



        }

        return path;
    }
    //
    //public static void main(String[] args) {
    //    String path = "aa[0].bb.cc";
    //    System.out.println(wrapperPath(path,"string"));
    //}
}
