package com.digiwin.athena.domain.core.app;

import com.digiwin.athena.domain.common.TenantObject;
import lombok.Getter;
import lombok.Setter;
import org.springframework.data.annotation.Transient;

/**
 * [DCP, PCC, athena_task_MO, PVQ, PWD, Athena, peter_test]
 **/
@Getter
@Setter
public class ApplicationRelation extends TenantObject {

    /**
     * 应用code
     */
    private String appCode;
    /**
     * 应用名称
     */
    private String appName;
    /**
     * 应用类型，数据驱动（1.0）：1，模型驱动（2.0）：5
     */
    private Integer appType;
    /**
     * 应用组件类型
     */
    private String type;

    /**
     * 源
     */
    private String source;

    /**
     * 是否公共应用
     */
    @Transient
    private Boolean commonApp;


    /**
     * 二级分类，基础资料设置为base_entry、表报statement，任务activity
     */
    private String subType;


    @Override
    public String entityBizCode() {
        return getCode() + appCode + type + subType;
    }
}
