package com.digiwin.athena.kg.monitorRule;



import com.digiwin.athena.kg.monitorRule.secondCalculate.QueryStepDTO;
import com.digiwin.athena.kg.monitorRule.product.ActionParamConfigDO;
import com.digiwin.athena.kg.monitorRule.product.DefaultParamConfigDO;
import com.digiwin.athena.kg.monitorRule.product.EntityMappingConfigDO;
import com.digiwin.athena.kg.monitorRule.product.FieldMappingConfigDO;
import com.digiwin.athena.kg.monitorRule.tenant.DynamicConditionConfigDO;
import com.digiwin.athena.kg.monitorRule.tenant.DynamicParamsDO;
import com.digiwin.athena.kg.monitorRule.tenant.ObserveDO;
import com.digiwin.athena.kg.monitorRule.tenant.StaticParamsDO;
import lombok.Data;
import org.springframework.data.mongodb.core.mapping.Document;

import java.util.List;
import java.util.Map;


@Data
@Document(collection = "monitorRuleProductConfig")
public class MonitorRuleProductConfig extends MonitorRuleConfig {

    private String productName;

    private EntityMappingConfigDO entityMapping;
    //fieldMapping用在returnColumns和dynamicCondition的列中
    private List<FieldMappingConfigDO> fieldMappings;
    private List<ActionParamConfigDO> actionParams;
    private List<DefaultParamConfigDO> defaultParams;
    //产品级的条件
    private DynamicConditionConfigDO dynamicCondition;
    private List<DynamicParamsDO> dynamicParams;
    private List<StaticParamsDO> staticParams;
    //是否去重字段
    private Boolean isPollingIds;

    //该侦测可以被设置的运营单元层级
    private String eocLevel;

    //存储过程名称以及参数配置
    private String procedure_name;
    private List<ProcedureParam> procedure_input;

    //是否需要去重，默认false.当设置true时必须配置bk_info
    private Boolean is_deduplication;
    private BkInfo2 bk_info;
    private String script;
    private Integer dbTag;

    private Integer executePageSize;


    private String table_name;

    private String change_type;

    private String eoc_company_id;

    private String eoc_site_id;

    private List<ChangeFieldsDTO> change_fields;

    private List<DynamicConditionConfigDO> filter_condition;

    private List<DynamicParamsDO> filter_params;

    private Boolean is_need_eoc;

    private String eoc_company_key;

    private String eoc_site_key;

    private String start_time;

    private String valid;

    private List<ObserveDO> observe;

    private String dbName;

    private Map<String,List<PullingParamDTO>> actionParamDefine;

    // 二次计算
    private Map<String,List<QueryStepDTO>> recast;

    public String entityBizCode(){

        return getMonitorRuleId()+getProductName();
    }

}
