package com.digiwin.athena.mechanism.widgets;



import com.digiwin.athena.config.ButtonDesign;
import com.digiwin.athena.config.ScheduleRule;
import com.digiwin.athena.mechanism.widgets.source.*;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import lombok.Data;

import java.util.List;

/**
 * @program: codes
 * @description: 机制执行的时机，目前包括
 *  1.项目、任务执行前后
 *  2.指定时间执行
 *  //检查类型 project task scheduled
 * @author: Tuo
 * @create: 2022-07-06 11:03
 **/
@Data
@JsonTypeInfo(use = JsonTypeInfo.Id.NAME,include = JsonTypeInfo.As.PROPERTY,property = "type",visible=true)
@JsonSubTypes({
        @JsonSubTypes.Type(value = ApiSourceWidget.class,name="apiSource"),
        @JsonSubTypes.Type(value = TaskSourceWidget.class,name="taskSource"),
        @JsonSubTypes.Type(value = ProjectSourceWidget.class,name="projectSource"),
        @JsonSubTypes.Type(value = ScheduleSourceWidget.class,name="scheduleSource"),
        @JsonSubTypes.Type(value = ScheduleApiSourceWidget.class,name="scheduleApiSource"),
        @JsonSubTypes.Type(value = DataEntrySourceWidget.class,name="dataEntrySource")
})
public class SourceWidget extends Widget {

    private String dataCode;
    //挂载点，如项目或者任务code
    private String target;
    private String targetName;

    /**
     * 针对2.0应用，大 T 的 code
     */
    private String targetFatherCode;
    //数据来源  tdd还是什么
    private String sourcePage;

    //机制任务触发后的执行策略，如任务开始后执行机制，机制需要延期执行
    //当type=scheduled则表示定期执行
    private ScheduleRule scheduleRule;

    private List<String> unikeys;

    /**
     * 任务描述
     */
    private String description;

    /**
     * 操作类型 限制能力多层级时使用数组，第一个参数是第一层，第二个参数是第二层
     */
    private List<String> operationTypes;

    /**
     * 操作类型
     */
    private String operationType;

    /**
     * 能力code
     */
    private String abilityCode;

    /**
     *  按钮信息
     */
    private ButtonDesign buttonInfo;

    /**
     *
     */
    private List<String> watchFields;

}
