package com.digiwin.athena.domain.plugin;

import lombok.Data;

import java.util.ArrayList;
import java.util.List;

/**
 * @program: athena_backend
 * @description: 描述
 * @author: Tuo
 * @create: 2021-05-31 16:06
 **/

@Data
public class PluginBindingPo {

    /**
     * 插件ID列表
     */
    private List<String> pluginIds;

    /**
     * 租户id,如果设置 仅对该租户生效
     */
    private String tenantId;
    /**
     * 是否强制绑定
     */
    private Boolean force;

    public static PluginBindingPo of(String tenantId, String pluginId){
        PluginBindingPo binding = new PluginBindingPo();
        binding.setTenantId(tenantId);
        binding.setPluginIds(new ArrayList<>());
        binding.getPluginIds().add(pluginId);
        return binding;
    }

    public static PluginBindingPo of(String tenantId, List<String> pluginIds){
        PluginBindingPo binding = new PluginBindingPo();
        binding.setTenantId(tenantId);
        binding.setPluginIds(pluginIds);
        return binding;
    }
}
