package com.digiwin.athena.mechanism.pre;


import com.digiwin.athena.domain.common.TenantObject;
import com.digiwin.athena.mechanism.common.MechanismVariable;
import lombok.Data;
import lombok.Getter;
import lombok.Setter;

import java.util.List;
import java.util.Map;

@Getter
@Setter
public class MechanismPartDoc extends TenantObject {

    /**
     * 归属：SYSTEM 或者某个应用 APP
     */
    private List<String> applications;
    //MechanismDecision MechanismControl MechanismLimit MechanismAssign MechanismDrive
    private List<String> abilities;
    //source check action
    private List<String> factors;
    //定义参数变量
    private List<MechanismVariable> variables;

    /**
     * 不兼容组件
    /**
     * 不兼容零件
     */
    private List<String> exclude;

    /**
     * 零件状态 是否启用  0：待启用  1：启用  -1：删除
     */
    private Integer status;

    /**
     * 扩展属性，对未定义零件领域的补充，未来再进行判断是否进领域
     */
    private Map<String, Object> features;

}
