package com.digiwin.athena.domain.core.process;

import lombok.Getter;

/**
 * 流程自定义变量-数据类型
 *
 * @author 於海兵
 */
public enum ProcessCustomVariableEnum {

    /**
     * boolean 布尔
     */
    BOOLEAN("Boolean"),

    /**
     * 整数
     */
    INTEGER("Integer"),

    /**
     * 小数
     */
    DECIMAL("Decimal"),

    /**
     * 文本
     */
    STRING("String"),

    /**
     * 时间
     */
    DATETIME("DateTime"),

    /**
     * 业务对象下拉选取(当前模型的拉下对象)
     */
    BUSINESS_OBJECT("BusinessObject"),

    /**
     * 流程变量
     */
    PROCESS("Process"),

    /**
     * 节点变量
     */
    NODE("Node"),

    /**
     * 模型变量
     */
    MODEL("Model"),

    /**
     * 机制参数
     */
    MECHANISM("Mechanism");

    @Getter
    private final String code;

    ProcessCustomVariableEnum(String code) {
        this.code = code;
    }
}
