package com.digiwin.athena.domain.definition;

import lombok.Data;

import java.util.List;
import java.util.Map;

/**
 * @author tang jie cheng
 * @date 2023-03-02 15:44
 */
@Data
public class ReminderRule {

    private boolean enable;
    /**
     * {
     * "type": "email" / "im"
     * }
     */
    private List<Map<String, Object>> notices;

    /**
     * aheadTimeType  minute/hour/day
     * aheadTimeValue   30
     */
    private Map<String, Object> aheadTime;

    /**
     *"             ruleType":  interval/count
     *            //按频率催办
     *             "interval":{
     *                 //按频率催办的时间单位，分钟/小时/天
     *                 "intervalType": "minute/hour/day",
     *                 //按频率催办的值
     *                 "intervalValue": 30
     *             },
     *
     *             //按次数催办
     *             "count":{
     *                 //按次数催办的次数
     *                 "countValue": 30
     *             }
     */
    private Map<String, Object> rule;

    /**
     * 支持多个规则， 原本的notices，aheadTime，rule都将放到rules的每个元素中，最外层只保留enable和rules
     */
    private List<Map<String, Object>> rules;

}
