package com.digiwin.athena.domain.core.process;

import lombok.Data;

/**
 * UI-数据映射字段
 */
@Data
public class DataMappingFields {

    /**
     * 当前节点名称
     */
    private String keyName;

    /**
     * 当前节点code
     */
    private String keyCode;

    /**
     * 映射目标名称
     */
    private String valueName;

    /**
     * 映射目标编码
     */
    private String valueCode;

    /**
     * 映射目标类型
     * 参照 ProcessCustomVariableEnum.code
     */
    private String valueType;

    /**
     * 映射目标全路径
     * 当valueType为BusinessObject时
     * valuePath为变映射目标编码，valueCode为映射目标全路径
     */
    private String valuePath;

    /**
     * 后缀
     */
    private String valueSuffix;
}
